package java.lang;

import java.io.*;
import java.util.Arrays;

/**
 *
 * @author Bruce
 */
public final class StringBuffer extends AbstractStringBuilder
{
    /**
     * A cache of the last value returned by toString. Cleared
     * whenever the StringBuffer is modified.
     */
    private transient char[] cacheStr;

    /**
     * Constructs a string buffer with initial capacity of 32.
     */
    public StringBuffer() {}

    /**
     * Constructs a string buffer with the specified initial capacity.
     *
     * @param cap the initial capacity.
     * @exception NegativeArraySizeException if the argument is less than 0
     */
    public StringBuffer(int cap) {}

    /**
     * Constructs a string buffer initialized to the contents of the
     * specified string.
     *
     * @param str initial contents
     */
    public StringBuffer(String str) {}

    public synchronized int length() {}

    public synchronized int capacity() {}

    public synchronized void ensureCapacity(int cap) {}

    public synchronized void trimToSize() {}

    public synchronized void setLength(int len) {}

    public synchronized char charAt(int idx) {}

    public synchronized void getChars(int start, int end, char[] arr, int ofs)
    {}

    public synchronized void setCharAt(int idx, char ch) {}

    public synchronized StringBuffer append(Object obj) {}

    public synchronized StringBuffer append(String str) {}

    public synchronized StringBuffer append(StringBuffer sb) {}

    synchronized StringBuffer append(AbstractStringBuilder asb) {}

    public synchronized StringBuffer append(char[] arr) {}

    public synchronized StringBuffer append(char[] arr, int ofs, int len) {}

    public synchronized StringBuffer append(boolean bool) {}

    public synchronized StringBuffer append(char ch) {}

    public synchronized StringBuffer append(int val) {}

    public synchronized StringBuffer append(long val) {}

    public synchronized StringBuffer append(float val) {}

    public synchronized StringBuffer append(double val) {}

    public synchronized StringBuffer delete(int start, int end) {}

    public synchronized StringBuffer deleteCharAt(int idx) {}

    public synchronized StringBuffer replace(int start, int end, String str) {}

    /**
     * Returns the balance of the string from a specified starting index.
     * 
     * @param start starting index of the substring
     * @return new String representing the specified substring
     */
    public synchronized String substring(int start) {}

    /**
     * Returns a portion of the string.
     * 
     * @param start starting index of the substring
     * @param end index following the substring (excluded)
     * @return new String representing the specified substring
     */
    public synchronized String substring(int start, int end) {}

    /**
     * Inserts a subset of a character array into the string at the specified offset.
     * 
     * @param idx point within the string to insert a portion of the character array
     * @param arr character array
     * @param ofs offset into the character array specifying the portion to insert
     * @param len length of substring from the array to be inserted
     * @return this object
     */
    public synchronized StringBuffer insert(int idx, char[] arr, int ofs, int len)
    {}

    /**
     * Inserts a string representation of the object into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the object
     * @param obj the object to insert
     * @return this object
     */
    public synchronized StringBuffer insert(int ofs, Object obj) {}

    /**
     * Inserts into the string at the specified offset.
     * 
     * @param ofs point within the string to insert
     * @param str string to be inserted
     * @return this object
     */
    public synchronized StringBuffer insert(int ofs, String str) {}

    /**
     * Inserts the character array into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the character array
     * @param arr character array
     * @return this object
     */
    public synchronized StringBuffer insert(int ofs, char[] arr) {}

    /**
     * Inserts "true" or "false" into the string at the specified offset based upon a boolean value.
     * 
     * @param ofs point within the string to insert the boolean
     * @param bool true inserts "true", false inserts "false"
     * @return this object
     */
    public StringBuffer insert(int ofs, boolean bool) {}

    /**
     * Inserts the a character into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the character
     * @param ch character to insert
     * @return this object
     */
    public synchronized StringBuffer insert(int ofs, char ch) {}

    /**
     * Inserts the string representation of a int value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val int value to represent
     * @return this object
     */
    public StringBuffer insert(int ofs, int val) {}

    /**
     * Inserts the string representation of a long value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val long value to represent
     * @return this object
     */
    public StringBuffer insert(int ofs, long val) {}

    /**
     * Inserts the string representation of a float value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val float value to represent
     * @return this object
     */
    public StringBuffer insert(int ofs, float val) {}

    /**
     * Inserts the string representation of a double value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val double value to represent
     * @return this object
     */
    public StringBuffer insert(int ofs, double val) {}

    /**
     * Returns the index within this string of the first occurrence of the specified substring.
     * 
     * @param str substring to match
     * @return index of the first occurrence of the substring
     */
    public int indexOf(String str) {}

    /**
     * Returns the index within this string of the first occurrence of the specified substring. The search
     * can begin at a specified offset.
     * 
     * @param str substring to match
     * @param from index offset to begin search
     * @return index of the first occurrence of the substring
     */
    public synchronized int indexOf(String str, int from) {}

    /**
     * Returns the index within this string of the last occurrence of the specified substring.
     * 
     * @param str substring to match
     * @return index of the last occurrence of the substring
     */
    public int lastIndexOf(String str) {}

    /**
     * Returns the index within this string of the last occurrence of the specified substring. The search
     * can begin at a specified offset.
     * 
     * @param str substring to match
     * @param from index offset to begin search
     * @return index of the last occurrence of the substring
     */
    public synchronized int lastIndexOf(String str, int from) {}

    /**
     * Returns a a new copy of the string.
     * 
     * @return new string
     */
    public synchronized String toString() {}
}
