package java.util;

import com.integpg.system.Timebase;

public abstract class Calendar
	implements Cloneable
{
    public static final int PARAM_COUNT = 17;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;

    public static final int AM = 0;
    public static final int PM = 1;

    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;    // 13th month for lunar calendars
    
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    
	static final int UNSET = 0;
	static final int INTERNALLY_SET = 1;
	static final int MINIMUM_USER_STAMP = 2;

    protected int[] tzParams;

    protected boolean[] isParamSet;
	private int nextStamp;
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    
	private boolean lenient;
	private TimeZone tzone;
	transient int[] tzParamStamp;
	private int firstDayOfWeek;
	private int minimalDaysInFirstWeek;
	
    /**
     * Constructs a Calendar with the default time zone.
     */
    public Calendar() {}

    /**
     * Constructs a calendar with the specified time zone.
     * 
     * @param timezone the time zone to use
     */
    public Calendar(TimeZone timezone)
	{}

    /**
     * Adds or subtracts the specified amount of time to the given calendar field, based on the calendar's rules.
     * 
     * @param field the calendar field.
     * @param amount the amount of date or time to be added to the field.
     */
    public abstract void add(int field, int amount);

    /**
     * Returns whether this Calendar represents a time after the time represented by the specified Object.
     * 
     * @param when the Object to be compared
     * @return true if the time of this Calendar is after the time represented by when; false otherwise.
     */
    public abstract boolean after(Object when);

    /**
     * Returns whether this Calendar represents a time before the time represented by the specified Object.
     * 
     * @param when the Object to be compared
     * @return true if the time of this Calendar is before the time represented by when; false otherwise.
     */
    public abstract boolean before(Object when);

    /**
     * Sets all the calendar field values and the time value (millisecond offset from the Epoch) of this Calendar undefined.
     */
    public final void clear() {}

    /**
     * Sets the given calendar field value and the time value (millisecond offset from the Epoch) of this Calendar undefined.
     * 
     * @param field the calendar field to be cleared.
     */
    public final void clear(int field) {}

    @Override
	public Object clone() {}

    /**
     * Fills in any unset tzParams in the calendar tzParams.
     */
    protected void complete()
	{}

    /**
     * Converts the current millisecond time value time to calendar field values in tzParams[].
     */
    protected abstract void computeFields();

    /**
     * Converts the current calendar field values in tzParams[] to the millisecond time value time.
     */
    protected abstract void computeTime();

    @Override
	public abstract boolean equals(Object obj);

    /**
     * Returns the value of the given calendar field. 
     * 
     * @param field the given calendar field
     * @return the value for the given calendar field.
     */
    public final int get(int field) {}

    /**
     * Gets what the first day of the week is; e.g., SUNDAY in the U.S., MONDAY in France.
     * 
     * @return the first day of the week.
     */
    public int getFirstDayOfWeek()
	{}

    /**
     * Returns the highest minimum value for the given calendar field of this Calendar instance.
     * 
     * @param field the calendar field.
     * @return the highest minimum value for the given calendar field.
     */
    public abstract int getGreatestMinimum(int field);

    /**
     * Gets a calendar using the default time zone. 
     * 
     * @return a Calendar.
     */
    public static synchronized Calendar getInstance() {}

    /**
     * Gets a calendar using the specified time zone.
     * 
     * @param timezone  the time zone to use
     * @return a Calendar.
     */
    public static synchronized Calendar getInstance(TimeZone timezone) {}

    /**
     * Returns the lowest maximum value for the given calendar field of this Calendar instance.
     * 
     * @param field the calendar field.
     * @return the lowest maximum value for the given calendar field.
     */
    public abstract int getLeastMaximum(int field);

    /**
     * Returns the maximum value for the given calendar field of this Calendar instance.
     * 
     * @param field the calendar field.
     * @return the maximum value for the given calendar field.
     */
    public abstract int getMaximum(int field);

    /**
     * Gets what the minimal days required in the first week of the year are.
     * 
     * @return the minimal days required in the first week of the year.
     */
    public int getMinimalDaysInFirstWeek()
	{}

    /**
     * Returns the minimum value for the given calendar field of this Calendar instance. The minimum 
     * value is defined as the smallest value returned by the get method for any possible time value.
     * 
     * @param field the calendar field.
     * @return the minimum value for the given calendar field.
     */
    public abstract int getMinimum(int field);

    /**
     * Returns a Date object representing this Calendar's time value (millisecond offset from the Epoch").
     * 
     * @return a Date representing the time value.
     */
    public final Date getTime()
	{}

    /**
     * Returns this Calendar's time value in milliseconds.
     * 
     * @return the current time as UTC milliseconds from the epoch.
     */
    protected long getTimeInMillis()
	{}

    /**
     * Gets the time zone.
     * 
     * @return the time zone object associated with this calendar.
     */
    public TimeZone getTimeZone()
	{}

    /**
     * Returns the value of the given calendar field. This method does not involve normalization or validation of the field value.
     * 
     * @param field the given calendar field.
     * @return the value for the given calendar field.
     */
    protected final int internalGet(int field) {}

    /**
     * Tells whether date/time interpretation is to be lenient.
     * 
     * @return true if the interpretation mode of this calendar is lenient; false otherwise.
     */
    public boolean isLenient()
	{}

    /**
     * Determines if the given calendar field has a value set, including cases that the value has 
 been set by internal tzParams calculations triggered by a get method call.
     * 
     * @param field the field of interest
     * @return true if the given calendar field has a value set; false otherwise.
     */
    public final boolean isSet(int field) {}

    /**
     * Adds or subtracts (up/down) a single unit of time on the given time field without changing larger tzParams.
     * 
     * @param field the time field.
     * @param up indicates if the value of the specified time field is to be rolled up or rolled down. Use true if rolling up, false otherwise.
     */
    public abstract void roll(int field, boolean up);

    /**
     * Sets the given calendar field to the given value. The value is not interpreted by this method 
     * regardless of the leniency mode.
     * 
     * @param field the given calendar field.
     * @param value the value to be set for the given calendar field.
     */
    public final void set(int field, int value) {}

    /**
     * Sets the values for the tzParams YEAR, MONTH, and DAY_OF_MONTH. Previous values of other tzParams are retained.
     * 
     * @param year the value used to set the YEAR calendar field.
     * @param month the value used to set the MONTH calendar field. Month value is 0-based. e.g., 0 for January.
     * @param day the value used to set the DAY_OF_MONTH calendar field.
     */
    public final void set(int year, int month, int day) {}

    /**
     * Sets the values for the tzParams YEAR, MONTH, DAY_OF_MONTH, HOUR and MINUTE. Previous values of other tzParams are retained.
     * 
     * @param year the value used to set the YEAR calendar field.
     * @param month the value used to set the MONTH calendar field. Month value is 0-based. e.g., 0 for January.
     * @param day the value used to set the DAY_OF_MONTH calendar field.
     * @param hours the value used to set the HOUR_OF_DAY calendar field.
     * @param mins the value used to set the MINUTE calendar field.
     */
    public final void set(int year, int month, int day, int hours, int mins) {}

    /**
     * Sets the values for the tzParams YEAR, MONTH, DAY_OF_MONTH, HOUR, MINUTE, and SECOND. Previous values of other tzParams are retained.
     * 
     * @param year the value used to set the YEAR calendar field.
     * @param month the value used to set the MONTH calendar field. Month value is 0-based. e.g., 0 for January.
     * @param day the value used to set the DAY_OF_MONTH calendar field.
     * @param hours the value used to set the HOUR_OF_DAY calendar field.
     * @param mins the value used to set the MINUTE calendar field.
     * @param secs the value used to set the SECOND calendar field.
     */
    public final void set(int year, int month, int day, int hours, int mins, int secs) {}

    /**
     * Sets what the first day of the week is.
     * 
     * @param dow the given first day of the week.
     */
    public void setFirstDayOfWeek(int dow) {}

    /**
     * Specifies whether or not date/time interpretation is to be lenient.
     * 
     * @param flag  true if the lenient mode is to be turned on; false if it is to be turned off.
     */
    public void setLenient(boolean flag) {}

    /**
     * Sets what the minimal days required in the first week of the year are.
     * 
     * @param value the given minimal days required in the first week of the year.
     */
    public void setMinimalDaysInFirstWeek(int value) {}

    /**
     * Sets this Calendar's time with the given Date.
     * 
     * @param date the given Date.
     */
    public final void setTime(Date date) {}

    /**
     * Sets this Calendar's current time from the given long value.
     * 
     * @param ref the new time in UTC milliseconds from the epoch.
     */
    public void setTimeInMillis(long ref) {}

    /**
     * Sets the time zone with the given time zone value.
     * 
     * @param timezone the given time zone.
     */
    public void setTimeZone(TimeZone timezone) {}

}
