package java.io;

import com.integpg.system.User;

/**
 *
 * @author Bruce Cloutier
 */
public class File {

    /**
     * The system-dependent default name-separator character, represented as a
     * string for convenience. This string contains a single character, namely
     * separatorChar.
     */
    public static final String separator = "/";

    /**
     * The system-dependent default name-separator character. This field is
     * initialized to contain the first character of the value of the system
     * property file.separator. On UNIX systems the value of this field is '/';
     * on Win32 systems it is '\'. JANOS will follow the UNIX standard and use
     * '/'.
     */
    public static final char separatorChar = "/".charAt(0);

    /**
     * The system-dependent path-separator character, represented as a string
     * for convenience. This string contains a single character, namely
     * pathSeparatorChar.
     */
    public static final String pathSeparator = ";";

    /**
     * The system-dependent path-separator character. This field is initialized
     * to contain the first character of the value of the system property
     * path.separator. This character is used to separate filenames in a
     * sequence of files given as a path list. On UNIX systems, this character
     * is ':'; on Win32 systems it is ';'. JANOS will use the Win32 standard ';'
     * as this seems more prevalent in our opinion.
     */
    public static final char pathSeparatorChar = ";".charAt(0);

    private String path;
    private transient String absolutePath;
    private transient byte nameBytes[];

    /**
     * Creates a new File instance by converting the given pathname string into
     * an abstract pathname. If the given string is the empty string, then the
     * result is the empty abstract pathname. If not specified from the root the
     * relative path will be taken from the current working directory.
     *
     * @param pathname the file path
     * @exception NullPointerException if path is null
     */
    public File(String pathname) {}

    /**
     * Creates a new File instance from a parent pathname string and a child
     * pathname string.
     *
     * If parent is null then the new File instance is created as if by invoking
     * the single-argument File constructor on the given child pathname string.
     *
     * Otherwise the parent pathname string is taken to denote a directory, and
     * the child pathname string is taken to denote either a directory or a
     * file.
     *
     * If the child pathname string is absolute then the parent directory is
     * ignored. If parent is the empty string then the new File instance is
     * created by converting child into an abstract pathname and resolving the
     * result against the current working directory. Otherwise a path is created
     * with the child defining a file or subfolder within the parent directory.
     * If the result is not specified from the root the relative path will be
     * taken from the current working directory.
     *
     * @param parent parent folder
     * @param child child subfolder or file
     * @exception NullPointerException if child is null
     */
    public File(String parent, String child) {}

    /**
     * Creates a new File instance from a parent pathname string and a child
     * pathname string.
     *
     * If parent is null then the new File instance is created as if by invoking
     * the single-argument File constructor on the given child pathname string.
     *
     * Otherwise the parent pathname string is taken to denote a directory, and
     * the child pathname string is taken to denote either a directory or a
     * file.
     *
     * If the child pathname string is absolute then the parent directory is
     * ignored. If parent is the empty string then the new File instance is
     * created by converting child into an abstract pathname and resolving the
     * result against the current working directory. Otherwise a path is created
     * with the child defining a file or subfolder within the parent directory.
     * If the result is not specified from the root the relative path will be
     * taken from the current working directory.
     *
     * @param parent parent folder
     * @param child child subfolder or file
     * @exception NullPointerException if child is null
     */
    public File(File parent, String child) {}

    /**
     * Native routine to build the absolute path structure.
     */
    private static native byte[] buildAbsolutePath(byte[] paparent, byte[] child);

    /**
     * Returns an estimate of the number of remaining bytes that can be read (or
     * skipped over) from this stream.
     *
     * @param obj handle?
     * @return remaining bytes
     */
    public static native int available(Object obj);

    /**
     * Tests whether the application can read the file denoted by this abstract
     * pathname.
     *
     * @return true if and only if the file specified by this abstract pathname
     * exists and can be read by the application; false otherwise
     */
    public boolean canRead() {}

    private static native boolean canReadFile(byte filespec[], int uid);

    /**
     * Tests whether the application can modify the file denoted by this
     * abstract pathname.
     *
     * @return true if and only if the file system actually contains a file
     * denoted by this abstract pathname and the application is allowed to write
     * to the file; false otherwise.
     */
    public boolean canWrite() {}

    private static native boolean canWriteFile(byte filespec[], int uid);

    static void checkBounds(byte abyte0[], int i, int j) {}

    /**
     * Closes the stream.
     *
     * @param obj handle
     * @throws IOException on error
     */
    void close(Object obj)
            throws IOException {}

    private static native void closeFile(Object obj);

    /**
     * Deletes the file.
     *
     * @return true if successful
     */
    public boolean delete() {}

    private static native boolean deleteFile(byte abyte0[], int uid);

    @Override
    public boolean equals(Object obj) {}

    /**
     *
     * @return ?
     */
    public boolean exists() {}

    private static native boolean isFileExists(byte abyte0[]);

    /**
     *
     * @return ?
     */
    public String getAbsolutePath() {}

    /**
     *
     * @return ?
     * @throws IOException ?
     */
    public String getCanonicalPath()
            throws IOException {}

    long getLength(Object obj)
            throws IOException {}

    private static native long getLengthFile(Object obj);

    /**
     *
     * @param obj ?
     * @param newLength ?
     * @throws IOException ?
     */
    public void setLength(Object obj, long newLength)
            throws IOException {}

    private static native void setLengthFile(Object obj, long len);

    /**
     * Sets the Last Modified timestamp for the file.
     *
     * @param newTime time
     */
    public void setLastModified(long newTime) {}

    private static native void setDateFile(byte[] name, long time);

    private static native String[] getFileList(byte search[]);

    /**
     *
     * @return ?
     */
    public String getName() {}

    long getOffset(Object obj)
            throws IOException {}

    private static native long getOffsetFile(Object obj);

    /**
     *
     * @return ?
     */
    public String getParent() {}

    /**
     *
     * @return ?
     */
    public String getPath() {}

    @Override
    public int hashCode() {}

    /**
     *
     * @return ?
     */
    public boolean isAbsolute() {}

    /**
     *
     * @return ?
     */
    public boolean isDirectory() {}

    /**
     * Queries a file's ARCHIVE attribute 
     * 
     * @return TRUE if the ARCHIVE bit is set
     */
    public boolean isArchive() {}

    /**
     * Clears or sets the ARCHIVE file attribute.
     * 
     * @param state 0 to clear the ARCHIVE bit, 1 (or NZ) to set it
     */
    public void setArchive(int state) {}
    
    /**
     *
     * @return ?
     */
    public boolean isFile() {}

    private static native boolean isFile(byte abyte0[], int i);

    /**
     *
     * @return ?
     */
    public long lastModified() {}

    private static native long lastModifiedByName(byte abyte0[]);

    /**
     *
     * @return ?
     */
    public long length() {}

    private static native long getLengthByName(byte abyte0[]);

    /**
     *
     * @return ?
     */
    public String[] list() {}

    /**
     *
     * @param filenamefilter ?
     * @return ?
     */
    public String[] list(FilenameFilter filenamefilter) {}

    /**
     *
     * @return ?
     */
    public boolean mkdir() {}

    private static native boolean mkdir(byte abyte0[], int uid);

    /**
     *
     * @return ?
     */
    public boolean mkdirs() {}

    Object openRandomFD()
            throws IOException {}

    private static native Object openFileRandom(byte abyte0[], int uid);

    Object openReadingFD()
            throws FileNotFoundException {}

    private static native Object openFileReading(byte abyte0[], int uid);

    Object openWritingFD(boolean flag)
            throws IOException {}

    private static native Object openFileWriting(byte abyte0[], boolean flag, int uid);

    int readBytes(Object obj, byte abyte0[], int i, int j)
            throws IOException {}

    private static native int readFile(Object obj, byte abyte0[], int i, int j);

    private static native boolean renameFile(byte abyte0[], byte abyte1[], int uid);

    /**
     *
     * @param file ?
     * @return ?
     */
    public boolean renameTo(File file) {}

    void seek(Object obj, long l)
            throws IOException {}

    private static native void seekFile(Object obj, int i);

    @Override
    public String toString() {}

    void writeBytes(Object obj, byte abyte0[], int i, int j)
            throws IOException {}

    private static native void writeFile(Object obj, byte abyte0[], int i, int j);
}
