//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/


package com.integpg.system;

import com.integpg.comm.ConsoleErrorStream;
import com.integpg.comm.ConsoleInputStream;
import com.integpg.comm.ConsoleOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Provides programmatic access to a Command Console session.
 * 
 * @author Bruce Cloutier
 */
public class ConsoleProcess extends Process
{
    private int pipe = 0;
    private int process = 0;
    
    private ConsoleInputStream stdout = null;
    private ConsoleErrorStream stderr = null;
    private ConsoleOutputStream stdin = null;
    
    /**
     * Creates a new ConsoleProcess. Will execute a command if provided. Inherits the current 
     * Environment unless one is specified. Upon completion of the command the console exits.
     * If a command is not provided the session is left at the command line prompt.
     * 
     * @param command optional command to be executed
     * @param env optional console environment
     */
    public ConsoleProcess(String command, Hashtable env) {}
    
    /**
     * Creates a new ConsoleProcess. Will execute a command if provided. Inherits the current 
     * Environment. Upon completion of the command the console exits. If a command is not
     * specified the session is left at the command line prompt.
     * 
     * @param command optional command to be executed
     */
    public ConsoleProcess(String command) {}
    
    /**
     * Creates a new ConsoleProcess. Inherits the current Environment. The command the console is 
     * left at the command line prompt.
     * 
     */
    public ConsoleProcess() {}
    
    /**
     * Closes the console connection and releases associated resources.
     */
    @Override
    public void destroy() {}
    
    /**
     * Closes the console process.
     */
    public void killProcess() {}
    
    /**
     * Queries the status of the console connection.
     * 
     * @return true if the console is still active
     */
    @Override
    public boolean isAlive() {}
    
    /** 
     * Queries the console input status.
     * 
     * @return TRUE if the console process is pending input
     * @since v1.5.1
     */
    public boolean isPrompted() {}
    private static native boolean consoleFlag(int process, int flag, boolean block);
    
    /** 
     * Blocks until the command process requests input.
     * 
     * @since v1.5.1
     */
    public void waitPrompt() {}
    /** 
     * Queries the console input status. Indicates that the console is at the command line
     * prompt requesting the entry of a new command.
     * 
     * @return TRUE if the console process is ready for command input
     * @since v1.5.1
     */
    public boolean isReady() {}
    
    /**
     * Obtains the most recent ERRORLEVEL (application return value).
     * 
     * @return errorlevel
     * @throws IllegalThreadStateException if the console is not active
     */
    @Override
    public int exitValue() throws IllegalThreadStateException
    {}
    
    /**
     * Creates an InputStream from which you can read output to stderr.
     * 
     * @return InputStream object
     */
    @Override
    public InputStream getErrorStream() {}

    /**
     * Creates an InputStream from which you can read output to stdout.
     * 
     * @return InputStream
     */
    @Override
    public InputStream getInputStream() {}

    /**
     * Creates an OutputStream through which you can enter characters to stdin.
     * 
     * @return OutputStream
     */
    @Override
    public OutputStream getOutputStream() {}
    
    /**
     * Returns the current console environment as a Hashtable.
     * 
     * @return environment hashtable 
     */
    public Hashtable getEnvironment() {}

    /**
     * Blocks for console exit.
     * 
     * @return errorlevel value returned by the process
     * @throws InterruptedException if interrupted before exit
     */
    @Override
    public int waitFor() throws InterruptedException 
    {}
    
    /**
     * Insures that the session is closed before releasing the object.
     * 
     * @throws Throwable on any exception
     */
    @Override
    protected void finalize() throws Throwable
    {}

    // Native methods - console
    private static native int consoleOpen(int pipe, String cmd, byte[] env);// start session
    private static native boolean consoleAlive(int process);    // indicate if session still running
    private static native void consoleClose(int process);       // end session
    private static native void consoleRelease(int process);     // release process data
    private static native int consoleExit(int process);         // get exit return - blocking
    private static native byte[] consoleGetEnv(int process);    // retrieve current environment content
    
    // Native methods - pipe
    private static native int pipeCreate(int insize, int outsize, int errsize); // create pipe set
    private static native void pipeRelease(int pipe);                           // release pipe set
}
