package java.net;

import java.io.*;

// Referenced classes of package java.net:
//			SocketException, SocketOptions, InetAddress
/**
 *
 * @author Bruce
 */
public abstract class SocketImpl
        implements SocketOptions {

    /**
     * address
     */
    protected InetAddress address;

    /**
     * port
     */
    protected int port;

    /**
     * localport
     */
    protected int localport;

    /**
     * FileDescriptor
     */
    protected FileDescriptor fd;
    int socketId;

    /**
     * SocketImpl
     */
    public SocketImpl() {}

    /**
     *
     * @param socketimpl ?
     * @throws IOException ?
     */
    protected abstract void accept(SocketImpl socketimpl)
            throws IOException;

    /**
     *
     * @return ?
     * @throws IOException ?
     */
    protected abstract int available()
            throws IOException;

    /**
     *
     * @param inetaddress ?
     * @param i ?
     * @throws IOException ?
     */
    protected abstract void bind(InetAddress inetaddress, int i)
            throws IOException;

    /**
     *
     * @throws IOException ?
     */
    protected abstract void close()
            throws IOException;

    /**
     *
     * @param s ?
     * @param i ?
     * @throws IOException ?
     */
    protected abstract void connect(String s, int i)
            throws IOException;

    /**
     *
     * @param inetaddress ?
     * @param i ?
     * @throws IOException ?
     */
    protected abstract void connect(InetAddress inetaddress, int i)
            throws IOException;

    /**
     *
     * @param stream ?
     * @throws IOException ?
     */
    protected abstract void create(boolean stream)
            throws IOException;

    /**
     *
     * @return ?
     */
    protected FileDescriptor getFileDescriptor() {}

    /**
     *
     * @return ?
     */
    protected InetAddress getInetAddress() {}

    /**
     *
     * @return ?
     * @throws IOException ?
     */
    protected abstract InputStream getInputStream()
            throws IOException;

    /**
     *
     * @return ?
     */
    protected int getLocalPort() {}

    /**
     *
     * @param i ?
     * @return ?
     * @throws SocketException ?
     */
    public abstract Object getOption(int i)
            throws SocketException;

    /**
     *
     * @return ?
     * @throws IOException ?
     */
    protected abstract OutputStream getOutputStream()
            throws IOException;

    /**
     *
     * @return ?
     */
    protected int getPort() {}

    abstract int getSoTimeout()
            throws SocketException;

    abstract void setSoTimeout(int i)
            throws SocketException;

    abstract void setSecure(boolean negotiate)
            throws SocketException;

    abstract void setServerName(String server)
            throws SocketException;

    abstract byte[] getCertificate()
            throws SocketException;

    abstract int getSoLinger()
            throws SocketException;

    abstract void setSoLinger(int i)
            throws SocketException;

    abstract boolean getTcpNoDelay()
            throws SocketException;

    abstract void setTcpNoDelay(boolean i)
            throws SocketException;

    abstract boolean getKeepAlive()
            throws SocketException;

    abstract void setKeepAlive(boolean i)
            throws SocketException;

    abstract int getSocketId();

    /**
     *
     * @param i ?
     * @throws IOException ?
     */
    protected abstract void listen(int i)
            throws IOException;

    /**
     *
     * @param i ?
     * @param obj ?
     * @throws SocketException ?
     */
    public abstract void setOption(int i, Object obj)
            throws SocketException;

    public String toString() {}
}
