//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/

package com.integpg.comm;

import com.integpg.system.JANOS;
import java.io.*;
import java.util.TooManyListenersException;

/**
 *
 * @author Bruce Cloutier
 */
public class SerialPort {

    /**
     * STDCOM
     */
    public static final int STDCOM = 4;

    /**
     * STDAUX
     */
    public static final int STDAUX = 5;

    /**
     * SPEED_110
     */
    public static final int SPEED_110 = 110;

    /**
     * SPEED_150
     */
    public static final int SPEED_150 = 150;

    /**
     * SPEED_300
     */
    public static final int SPEED_300 = 300;

    /**
     * SPEED_600
     */
    public static final int SPEED_600 = 600;

    /**
     * SPEED_1200
     */
    public static final int SPEED_1200 = 1200;

    /**
     * SPEED_2400
     */
    public static final int SPEED_2400 = 2400;

    /**
     * SPEED_4800
     */
    public static final int SPEED_4800 = 4800;

    /**
     * SPEED_9600
     */
    public static final int SPEED_9600 = 9600;

    /**
     * SPEED_14400
     */
    public static final int SPEED_14400 = 14400;

    /**
     * SPEED_19200
     */
    public static final int SPEED_19200 = 19200;

    /**
     * SPEED_28800
     */
    public static final int SPEED_28800 = 28800;

    /**
     * SPEED_31250
     */
    public static final int SPEED_31250 = 31250;

    /**
     * SPEED_38400
     */
    public static final int SPEED_38400 = 38400;

    /**
     * SPEED_56000
     */
    public static final int SPEED_56000 = 56000;

    /**
     * SPEED_57600
     */
    public static final int SPEED_57600 = 57600;

    /**
     * SPEED_115200
     */
    public static final int SPEED_115200 = 115200;

    /**
     * SPEED_128000
     */ 
    public static final int SPEED_128000 = 128000;

    /**
     * SPEED_250000
     */ 
    public static final int SPEED_250000 = 250000;

    /**
     * DATABITS_7
     */
    public static final int DATABITS_7 = 7;

    /**
     * DATABITS_8
     */
    public static final int DATABITS_8 = 8;

    /**
     * STOPBITS_1
     */
    public static final int STOPBITS_1 = 1;

    /**
     * STOPBITS_2
     */
    public static final int STOPBITS_2 = 2;

    /**
     * PARITY_NONE
     */
    public static final int PARITY_NONE = 0;

    /**
     * PARITY_ODD
     */
    public static final int PARITY_ODD = 1;

    /**
     * PARITY_EVEN
     */
    public static final int PARITY_EVEN = 2;

    /**
     * FLOWCONTROL_NONE
     */
    public static final int FLOWCONTROL_NONE = 0;

    /**
     * FLOWCONTROL_RTSCTS_IN
     */
    public static final int FLOWCONTROL_RTSCTS_IN = 1;

    /**
     * FLOWCONTROL_RTSCTS_OUT
     */
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;

    /**
     * FLOWCONTROL_XONXOFF_IN
     */
    public static final int FLOWCONTROL_XONXOFF_IN = 4;

    /**
     * FLOWCONTROL_XONXOFF_OUT
     */
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;

    static final int PORT_STATE_CLOSED = 0;
    static final int PORT_STATE_OPEN = 1;

    boolean isOpen = false;
    SerialPortEventListener eventListener;
    SerialPortThread serialthread;

    static final int DEFAULT_SERIAL_READ_TIMEOUT = 0x3FFFFFFF;
    static final int NOTIFY_ON_CTS = 1;
    static final int NOTIFY_ON_PARITY_ERROR = 2;
    static final int NOTIFY_ON_OVERRUN_ERROR = 4;
    static final int NOTIFY_ON_FRAMING_ERROR = 8;
    static final int NOTIFY_ON_OUTPUT_EMPTY = 16;
    static final int NOTIFY_ON_DATA_AVAILABLE = 32;
    static final int NOTIFY_ON_BREAK_INTERRUPT = 64;

    boolean requestedNotifyOnDataAvailable;
    boolean requestedNotifyOnOutputEmpty;
    boolean requestedNotifyOnCTS;
    boolean requestedNotifyOnOverrunError;
    boolean requestedNotifyOnParityError;
    boolean requestedNotifyOnFramingError;
    boolean requestedNotifyOnBreakInterrupt;

    private int threshold = 1;
    private int receiveTimeout = DEFAULT_SERIAL_READ_TIMEOUT;
    private int flowControl = SerialPort.FLOWCONTROL_NONE;
    private static String[] portNames;

    int portNum;
    private static boolean owned = false;
    private static String owner;
    int portState;
    private SerialInputStream inputStream;
    private SerialOutputStream outputStream;

    private static native int commGetBaudRate(int handle);
    private static native int commGetFlow(int handle);
    private static native int commGetFormat(int handle);
    private static native int commGetOwnerProcID(int port);
    private static native void commSendBreak(int handle, int millis);
    private static native void commSetBaudRate(int handle, int baudrate);
    private static native void commSetFlow(int handle, int n);
    private static native void commSetFormat(int handle, int n);
    private static native boolean commSetOwnership(int port, boolean own);

    /**
     * Initializer used only when instantiating AUXSerialPort.class and COMSerialPort.class.
     * @param port Defines serial port (COM = 4, AUX = 6).
     * @throws IllegalArgumentException when the parameter is not recognized.
     */
    protected SerialPort(int port) {}

    /**
     * A serial port must be opened in order to gain access to its streams. This allows the process
     * to take ownership of the port and this instance of the port class to take control.
     * @throws PortInUseException when this or another process already has control of this resource
     * @throws IOException if a stream cannot be created
     */
    public void open() throws PortInUseException, IOException {}

    /**
     * Closes the serial port and associated streams.
     */
    public void close() {}

    /**
     *
     * @param baudRate ?
     * @param dataBits ?
     * @param stopBits ?
     * @param parity ?
     * @throws UnsupportedCommOperationException ?
     */
    public void setSerialPortParams(int baudRate, int dataBits, int stopBits, int parity)
            throws UnsupportedCommOperationException {}

     /**
     * Returns the ports current baud rate in bits per second.
     *
     * @return the current baud rate
     */
    public int getBaudRate() {}

    /**
     *
     * @param dataBits ?
     * @param stopBits ?
     * @param parity ?
     * @throws UnsupportedCommOperationException ?
     */
    public void setBitParameters(int dataBits, int stopBits, int parity)
            throws UnsupportedCommOperationException {}


    /**
     * Returns the ports current the data bit (word size) setting.
     *
     * @return the current word size
     */
    public int getDataBits() {}

    /**
     * Returns the ports current stop bits setting.
     *
     * @return the current stop bits
     */
    public int getStopBits() {}

    /**
     * Returns the ports current parity setting.
     *
     * @return the current parity
     */
    public int getParity() {}

    /** Returns the InputStream associated with this port.
     *
     * @return the InputStream associated with this port
     *
     * @throws IOException if the stream is not available
     * @throws IllegalStateException if the port is not open
     */
    public SerialInputStream getInputStream() throws IOException {}

    /** Returns the OutputStream associated with this port.
     *
     * @return the OutputStream associated with this port
     *
     * @throws IOException if the stream is not available
     * @throws IllegalStateException if the port is not open
     */
    public SerialOutputStream getOutputStream() throws IOException {}

    /**
     * Sets the ports flow control mode.
     *
     * @param flow ?
     * @throws com.integpg.comm.UnsupportedCommOperationException ?
     * @throws IllegalStateException if the port is not open
     */
    public void setFlowControlMode(int flow)
            throws UnsupportedCommOperationException {}

    /**
     * Returns the ports current flow control mode.
     *
     * @return the current flow control mode
     * @see #setFlowControlMode(int flow)
     */
    public int getFlowControlMode() {}

    /**
     * Creates a serial Break condition for the defined period in milliseconds. As of 
     * v1.6.2 this no longer sleeps for the duration of the break.
     *
     * @param millis desired duration of the break in milliseconds
     *
     * @throws IllegalStateException if the port is not open
     */
    public void sendBreak(int millis) {}





    /**
     * Adds an event listener for the port. A new Thread will be created to
     * manage events as soon as one of the notifyOn methods are called.
     *
     * @param eventListener listener class to be installed
     *
     * @throws IllegalStateException if the port is not open
     * @throws TooManyListenersException if the maximum number of listeners has
     *         been installed
     */
    public void addEventListener(SerialPortEventListener eventListener)
            throws TooManyListenersException {}

    /**
     * Removes an event listener. This method removes all threads associated
     * with event listeners when the last listener is removed.
     */
    public synchronized void removeEventListener() {}

    /**
     * Requests notification when data is available to read.
     * This method will create a new Thread to manage events if one has not already been
     * created.
     *
     * @param enable set to true to enable
     */
    public void notifyOnDataAvailable(boolean enable) {}

    private void addNotification(boolean enable, int eventType) {}

    private static native void commAddNotify(int handle, boolean enable, int type);

    /**
     * Requests notification when output buffer is empty. This method
     * will create a new Thread to manage events if one has not already been
     * created.
     *
     * @param enable set to true to enable
     */
    public void notifyOnOutputEmpty(boolean enable) {}

    /**
     * Requests notification when CTS changes state. This method
     * will create a new Thread to manage events if one has not already been
     * created.
     *
     * @param enable set to true to enable
     */
    public void notifyOnCTS(boolean enable) {}

    /**
     * Requests notification when overrun error occurs. This method
     * will create a new Thread to manage events if one has not already been
     * created.
     *
     * @param enable set to true to enable
     */
    public void notifyOnOverrunError(boolean enable) {}

    /**
     * Requests notification when parity error occurs. This method
     * will create a new Thread to manage events if one has not already been
     * created.
     *
     * @param enable set to true to enable
     */
    public void notifyOnParityError(boolean enable) {}

    /**
     * Requests notification when framing error occurs. This method
     * will create a new Thread to manage events if one has not already been
     * created.
     *
     * @param enable set to true to enable
     */
    public void notifyOnFramingError(boolean enable) {}

    /**
     * Requests notification when break interrupt occurs. This method
     * will create a new Thread to manage events if one has not already been
     * created.
     *
     * @param enable set to true to enable
     */
    public void notifyOnBreakInterrupt(boolean enable) {}

    /**
     * Enables the ports receive threshold.
     *
     * @param thresh - Desired read threshold
     *
     * @throws UnsupportedCommOperationException if thresh &lt; 0
     * @throws IllegalStateException if the InputStream is not accessable
     */
    public void enableReceiveThreshold(int thresh)
            throws UnsupportedCommOperationException {}

    /**
     * Disables the ports receive threshold.
     */
    public void disableReceiveThreshold() {}

    /**
     * Returns the ports threshold enable state. Used by
     *  <code>javax.comm.SerialPort</code>.
     *
     * @return true if receive threshold is enabled
     */
    public boolean isReceiveThresholdEnabled() {}

    /**
     * Returns the ports threshold enable state.
     *
     * @return true if receive threshold is enabled
     */
    public int getReceiveThreshold() {}

    /**
     * Enables the ports receive timeout.
     *
     * @param rcvTimeout timeout in milliseconds
     *
     * @throws UnsupportedCommOperationException if rcvTimeout &lt; 0
     * @throws IllegalStateException if the port is closed
     */
    public void enableReceiveTimeout(int rcvTimeout)
            throws UnsupportedCommOperationException {}

    /**
     * Disables the ports receive timeout.
     *
     * @throws IllegalStateException if the port is closed
     */
    public void disableReceiveTimeout() {}

    /**
     * Returns the ports receive timeout enable state.
     *
     * @return true if receive timeout is enabled
     */
    public boolean isReceiveTimeoutEnabled() {}

    /**
     * Returns the ports current receive timeout.
     *
     * @return the current timeout value
     */
    public int getReceiveTimeout() {}

    /**
     *
     * @param framingByte ?
     * @throws UnsupportedCommOperationException ?
     */
    public void enableReceiveFraming(int framingByte)
            throws UnsupportedCommOperationException {}

    /**
     * Disables the ports receive framing.
     */
    public void disableReceiveFraming() {}

    /**
     * Returns the ports receive framing enable state.
     *
     *  @return false always
     */
    public boolean isReceiveFramingEnabled() {}

    /**
     * Returns the ports receive framing byte.
     *
     * @return -1 always
     */
    public int getReceiveFramingByte() {}

    /**
     * Sets the ports input buffer size.
     *
     * @param size number of bytes to use for the input receive buffer
     */
    public void setInputBufferSize(int size) {}

    private static native void commSetBuffer(int handle, int size);

    /**
     * Returns the ports input buffer size.
     *
     * @return the current input buffer size
     */
    public int getInputBufferSize() {}

    private static native int commGetBuffer(int handle);

    /**
     * Sets the ports output buffer size.
     *
     * @param size number of bytes to use for the output transmit buffer
     */
    public void setOutputBufferSize(int size) {}

    private static native void commSetOutBuffer(int handle, int size);

    /**
     * Returns the ports current output buffer size.
     *
     * @return the current output buffer size
     */
    public int getOutputBufferSize() {}

    private static native int commGetOutBuffer(int handle);

    static String[] getPortNames() {}

}

class SerialPortThread extends Thread {

    private boolean eventListenerEnabled;
    private SerialPortEvent serialPortEvent;
    private SerialPort jSerialPort;

    private native int waitOnSerialNotify(int portNum);

    SerialPortThread() {}

    public SerialPortThread(SerialPort serialport) {}

    private native void stopSerialNotify(int port);

    void stopEventListener() {}

    @Override
    public void run() {}

    public void fireEvent(int event, int reason) {}
}
