package java.util;

import com.integpg.system.ArrayUtils;
import com.integpg.system.Timebase;

// Referenced classes of package java.util:
//			Calendar, GregorianCalendar, StringTokenizer, TimeZone
/**
 *
 * @author Bruce Cloutier
 */
public class Date
        implements Cloneable {

    private transient Calendar gCalendar;

    /**
     * Allocates a <code>Date</code> object and initializes it so that it represents the time at which it was allocated,
     * measured to the nearest millisecond.
     *
     * @see com.integpg.system.Timebase#currentTimeMillis()
     */
    public Date() {}

    /**
     * Allocates a <code>Date</code> object and initializes it so that it represents midnight, local time, at the beginning of
     * the day specified by the <code>year</code>, <code>month</code>, and <code>date</code> arguments.
     *
     * @param year the year minus 1900.
     * @param month the month between 0-11.
     * @param date the day of the month between 1-31.
     * @see java.util.Calendar replaced by <code>Calendar.set(year + 1900, month, date)</code> or
     * <code>GregorianCalendar(year + 1900, month, date)</code>.
     */
    public Date(int year, int month, int date) {}

    /**
     * Allocates a <code>Date</code> object and initializes it so that it represents the instant at the start of the minute
     * specified by the <code>year</code>, <code>month</code>, <code>date</code>, <code>hrs</code>, and <code>min</code>
     * arguments, in the local time zone.
     *
     * @param year the year minus 1900.
     * @param month the month between 0-11.
     * @param date the day of the month between 1-31.
     * @param hrs the hours between 0-23.
     * @param min the minutes between 0-59.
     * @see java.util.Calendar
     */
    public Date(int year, int month, int date, int hrs, int min) {}

    /**
     * Allocates a <code>Date</code> object and initializes it so that it represents the instant at the start of the second
     * specified by the <code>year</code>, <code>month</code>, <code>date</code>, <code>hrs</code>, <code>min</code>, and
     * <code>sec</code> arguments, in the local time zone.
     *
     * @param year the year minus 1900.
     * @param month the month between 0-11.
     * @param date the day of the month between 1-31.
     * @param hrs the hours between 0-23.
     * @param min the minutes between 0-59.
     * @param sec the seconds between 0-59.
     * @see java.util.Calendar
     */
    public Date(int year, int month, int date, int hrs, int min, int sec) {}

    /**
     * Allocates a <code>Date</code> object and initializes it to represent the specified number of milliseconds since the
     * standard base time known as "the epoch", namely January 1, 1970, 00:00:00 GMT.
     *
     * @param time the milliseconds since January 1, 1970, 00:00:00 GMT.
     * @see java.lang.System#currentTimeMillis()
     */
    public Date(long time) {}

    /**
     * Allocates a <code>Date</code> object and initializes it so that it represents the date and time indicated by the string
     * <code>s</code>, which is interpreted as if by the {@link Date#parse} method.
     *
     * @param datestr a string representation of the date.
     * @see java.text.DateFormat
     * @see java.util.Date#parse(java.lang.String)
     */
    public Date(String datestr) throws IllegalArgumentException {}

    /**
     * Determines the date and time based on the arguments. The arguments are interpreted as a year, month, day of the month,
     * hour of the day, minute within the hour, and second within the minute, exactly as for the <code>Date</code> constructor with
     * six arguments, except that the arguments are interpreted relative to UTC rather than to the local time zone. The time
     * indicated is returned represented as the distance, measured in milliseconds, of that time from the epoch (00:00:00 GMT on
     * January 1, 1970).
     *
     * @param year the year minus 1900.
     * @param month the month between 0-11.
     * @param date the day of the month between 1-31.
     * @param hrs the hours between 0-23.
     * @param min the minutes between 0-59.
     * @param sec the seconds between 0-59.
     * @return the number of milliseconds since January 1, 1970, 00:00:00 GMT for the date and time specified by the arguments.
     */
    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {}

    /**
     * Tests if this date is after the specified date.
     *
     * @param when a date.
     * @return  <code>true</code> if and only if the instant represented by this <code>Date</code> object is strictly later than the
     * instant represented by <code>when</code>; <code>false</code> otherwise.
     * @exception NullPointerException if <code>when</code> is null.
     */
    public boolean after(Date when) {}

    /**
     * Tests if this date is before the specified date.
     *
     * @param when a date.
     * @return  <code>true</code> if and only if the instant of time represented by this <code>Date</code> object is strictly earlier
     * than the instant represented by <code>when</code>; <code>false</code> otherwise.
     * @exception NullPointerException if <code>when</code> is null.
     */
    public boolean before(Date when) {}

    /**
     * Compares two dates for equality. The result is <code>true</code> if and only if the argument is not <code>null</code> and
     * is a <code>Date</code> object that represents the same point in time, to the millisecond, as this object.
     * <p>
     * Thus, two <code>Date</code> objects are equal if and only if the <code>getTime</code> method returns the same
     * <code>long</code> value for both.
     *
     * @param obj the object to compare with.
     * @return  <code>true</code> if the objects are the same; <code>false</code> otherwise.
     * @see java.util.Date#getTime()
     */
    public boolean equals(Object obj) {}

    /**
     * Returns the day of the month represented by this <code>Date</code> object. The value returned is between <code>1</code> and
     * <code>31</code> representing the day of the month that contains or begins with the instant in time represented by this
     * <code>Date</code> object, as interpreted in the local time zone.
     *
     * @return the day of the month represented by this date.
     * @see java.util.Calendar
     */
    public int getDate() {}

    /**
     * Returns the day of the week represented by this date. The returned value (<code>0</code> = Sunday, <code>1</code> = Monday,
     * <code>2</code> = Tuesday, <code>3</code> = Wednesday, <code>4</code> = Thursday, <code>5</code> = Friday, <code>6</code> = Saturday)
     * represents the day of the week that contains or begins with the instant in time represented by this <code>Date</code> object,
     * as interpreted in the local time zone.
     *
     * @return the day of the week represented by this date.
     * @see java.util.Calendar
     */
    public int getDay() {}

    /**
     * Returns the hour represented by this <code>Date</code> object. The returned value is a number (<code>0</code> through
     * <code>23</code>) representing the hour within the day that contains or begins with the instant in time represented by this
     * <code>Date</code>
     * object, as interpreted in the local time zone.
     *
     * @return the hour represented by this date.
     * @see java.util.Calendar
     */
    public int getHours() {}

    /**
     * Returns the number of minutes past the hour represented by this date, as interpreted in the local time zone. The value
     * returned is between <code>0</code> and <code>59</code>.
     *
     * @return the number of minutes past the hour represented by this date.
     * @see java.util.Calendar
     */
    public int getMinutes() {}

    /**
     * Returns a number representing the month that contains or begins with the instant in time represented by this
     * <code>Date</code> object. The value returned is between <code>0</code> and <code>11</code>, with the value <code>0</code>
     * representing January.
     *
     * @return the month represented by this date.
     * @see java.util.Calendar
     */
    public int getMonth() {}

    /**
     * Returns the number of seconds past the minute represented by this date. The value returned is between <code>0</code> and
     * <code>61</code>. The values <code>60</code> and <code>61</code> can only occur on those Java Virtual Machines that take
     * leap seconds into account.
     *
     * @return the number of seconds past the minute represented by this date.
     * @see java.util.Calendar
     */
    public int getSeconds() {}

    /**
     * Returns the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this <code>Date</code> object.
     *
     * @return the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by this date.
     */
    public long getTime() {}

    /**
     * Returns the offset, measured in minutes, for the local time zone relative to UTC that is appropriate for the time
     * represented by this <code>Date</code> object.
     * <p>
     * For example, in Massachusetts, five time zones west of Greenwich:
     * <blockquote><pre>
     * new Date(96, 1, 14).getTimezoneOffset() returns 300</pre></blockquote>
     * because on February 14, 1996, standard time (Eastern Standard Time) is in use, which is offset five hours from UTC; but:
     * <blockquote><pre>
     * new Date(96, 5, 1).getTimezoneOffset() returns 240</pre></blockquote>
     * because on June 1, 1996, daylight saving time (Eastern Daylight Time) is in use, which is offset only four hours from
     * UTC.<p>
     * This method produces the same result as if it computed:
     * <blockquote><pre>
     * (this.getTime() - UTC(this.getYear(),
     *                       this.getMonth(),
     *                       this.getDate(),
     *                       this.getHours(),
     *                       this.getMinutes(),
     *                       this.getSeconds())) / (60 * 1000)
     * </pre></blockquote>
     *
     * @return the time-zone offset, in minutes, for the current time zone.
     * @see java.util.Calendar#ZONE_OFFSET
     * @see java.util.Calendar#DST_OFFSET
     * @see java.util.TimeZone#getDefault
     */
    public int getTimezoneOffset() {}

    /**
     * Returns a value that is the result of subtracting 1900 from the year that contains or begins with the instant in time
     * represented by this <code>Date</code> object, as interpreted in the local time zone.
     *
     * @return the year represented by this date, minus 1900.
     * @see java.util.Calendar
     */
    public int getYear() {}

    /**
     * Returns a hash code value for this object. The result is the exclusive OR of the two halves of the primitive
     * <code>long</code>
     * value returned by the {@link Date#getTime} method. That is, the hash code is the value of the expression:
     *
     * @return a hash code value for this object.
     */
    public int hashCode() {}

    /**
     *
     * @param format Format 0 - dd mmm yyyy hh:mm:ss zzz 1 - www mmm dd hh:mm:ss zzz yyyy 2 - dd mmm yyyy hh:mm:ss GMT
     * @return String representation of the current date
     */
    private String myFormat(int format) {}

    /**
     * Attempts to interpret the string <code>s</code> as a representation of a date and time. If the attempt is successful, the
     * time indicated is returned represented as the distance, measured in milliseconds, of that time from the epoch (00:00:00
     * GMT on January 1, 1970). If the attempt fails, an
     * <code>IllegalArgumentException</code> is thrown.
     * <p>
     * It accepts many syntaxes; in particular, it recognizes the IETF standard date syntax: "Sat, 12 Aug 1995 13:30:00 GMT". It
     * also understands the continental U.S. time-zone abbreviations, but for general use, a time-zone offset should be used:
     * "Sat, 12 Aug 1995 13:30:00 GMT+0430" (4 hours, 30 minutes west of the Greenwich meridian). If no time zone is specified,
     * the local time zone is assumed. GMT and UTC are considered equivalent.
     * <p>
     * The string <code>s</code> is processed from left to right, looking for data of interest. Any material in <code>s</code> that is
     * within the ASCII parenthesis characters <code>(</code> and <code>)</code> is ignored. Parentheses may be nested. Otherwise, the
     * only characters permitted within <code>s</code> are these ASCII characters:
     * <blockquote><pre>
     * abcdefghijklmnopqrstuvwxyz
     * ABCDEFGHIJKLMNOPQRSTUVWXYZ
     * 0123456789,+-:/</pre></blockquote>
     * and whitespace characters.<p>
     * A consecutive sequence of decimal digits is treated as a decimal number:<ul>
     * <li>If a number is preceded by <code>+</code> or <code>-</code> and a year has already been recognized, then the number is a
     * time-zone offset. If the number is less than 24, it is an offset measured in hours. Otherwise, it is regarded as an
     * offset in minutes, expressed in 24-hour time format without punctuation. A preceding <code>-</code> means a westward offset.
     * Time zone offsets are always relative to UTC (Greenwich). Thus, for example,
     * <code>-5</code> occurring in the string would mean "five hours west of Greenwich" and <code>+0430</code> would mean "four hours
     * and thirty minutes east of Greenwich." It is permitted for the string to specify <code>GMT</code>, <code>UT</code>, or
     * <code>UTC</code>
     * redundantly-for example, <code>GMT-5</code> or <code>utc+0430</code>.
     * <li>The number is regarded as a year number if one of the following conditions is true:
     * <ul>
     * <li>The number is equal to or greater than 70 and followed by a space, comma, slash, or end of string
     * <li>The number is less than 70, and both a month and a day of the month have already been recognized</li>
     * </ul>
     * If the recognized year number is less than 100, it is interpreted as an abbreviated year relative to a century of which
     * dates are within 80 years before and 19 years after the time when the Date class is initialized. After adjusting the year
     * number, 1900 is subtracted from it. For example, if the current year is 1999 then years in the range 19 to 99 are assumed
     * to mean 1919 to 1999, while years from 0 to 18 are assumed to mean 2000 to 2018. Note that this is slightly different
     * from the interpretation of years less than 100 that is used in {@link java.text.SimpleDateFormat}.
     * <li>If the number is followed by a colon, it is regarded as an hour, unless an hour has already been recognized, in which
     * case it is regarded as a minute.
     * <li>If the number is followed by a slash, it is regarded as a month (it is decreased by 1 to produce a number in the
     * range <code>0</code>
     * to <code>11</code>), unless a month has already been recognized, in which case it is regarded as a day of the month.
     * <li>If the number is followed by whitespace, a comma, a hyphen, or end of string, then if an hour has been recognized but
     * not a minute, it is regarded as a minute; otherwise, if a minute has been recognized but not a second, it is regarded as
     * a second; otherwise, it is regarded as a day of the month. </ul><p>
     * A consecutive sequence of letters is regarded as a word and treated as follows:<ul>
     * <li>A word that matches <code>AM</code>, ignoring case, is ignored (but the parse fails if an hour has not been recognized or
     * is less than <code>1</code> or greater than <code>12</code>).
     * <li>A word that matches <code>PM</code>, ignoring case, adds <code>12</code>
     * to the hour (but the parse fails if an hour has not been recognized or is less than <code>1</code> or greater than
     * <code>12</code>).
     * <li>Any word that matches any prefix of <code>SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY</code>, or
     * <code>SATURDAY</code>, ignoring case, is ignored. For example, <code>sat, Friday, TUE</code>, and
     * <code>Thurs</code> are ignored.
     * <li>Otherwise, any word that matches any prefix of <code>JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST,
     * SEPTEMBER, OCTOBER, NOVEMBER</code>, or <code>DECEMBER</code>, ignoring case, and considering them in the order given here, is
     * recognized as specifying a month and is converted to a number (<code>0</code> to
     * <code>11</code>). For example, <code>aug, Sept, april</code>, and
     * <code>NOV</code> are recognized as months. So is <code>Ma</code>, which is recognized as <code>MARCH</code>, not <code>MAY</code>.
     * <li>Any word that matches <code>GMT, UT</code>, or <code>UTC</code>, ignoring case, is treated as referring to UTC.
     * <li>Any word that matches <code>EST, CST, MST</code>, or <code>PST</code>, ignoring case, is recognized as referring to the time
     * zone in North America that is five, six, seven, or eight hours west of Greenwich, respectively. Any word that matches
     * <code>EDT, CDT, MDT</code>, or <code>PDT</code>, ignoring case, is recognized as referring to the same time zone, respectively,
     * during daylight saving time.</ul><p>
     * Once the entire string s has been scanned, it is converted to a time result in one of two ways. If a time zone or
     * time-zone offset has been recognized, then the year, month, day of month, hour, minute, and second are interpreted in UTC
     * and then the time-zone offset is applied. Otherwise, the year, month, day of month, hour, minute, and second are
     * interpreted in the local time zone.
     *
     * @param datestr a string to be parsed as a date.
     * @return the number of milliseconds since January 1, 1970, 00:00:00 GMT represented by the string argument.
     * @see java.text.DateFormat
     */
    public static long parse(String datestr) {