//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/

package com.integpg.system;

import java.io.PrintStream;

/**
 * This class only applies to DEBUG builds of JANOS. Use only as directed.
 * 
 * @author Bruce Cloutier
 */
public class Debug {

   // Do not allow instantiate
   private Debug ()
   {}

    /**
     * Enables the JVM opcode trace mode. This is valid only with DEBUG builds of JANOS. Debug builds are
     * only available within INTEG.
     * 
     * @param mode true to enable
     */
    public static native void setOpcodeTrace(int mode);
    
    /**
     * Output byte[] content in traditional dump format.
     * 
     * @param data byte array to be dumped
     */
    public static void dump(byte[] data) {}
    
    /**
     * Output byte[] content in traditional dump format.
     * 
     * @param data byte array to be dumped
     * @param len count of bytes to dump
     */
    public static void dump(byte[] data, int len) {}
    
    /**
     * Output byte[] content in traditional dump format.
     * 
     * @param data byte array to be dumped
     * @param len count of bytes to dump
     * @param out PrintStream to receive the dump
     */
    public static void dump(byte[] data, int len, PrintStream out) {}
}
