package java.util;

/**
 * The Stack class represents a last-in-first-out (LIFO) stack of objects. It extends class 
 * Vector with five operations that allow a vector to be treated as a stack. The usual push 
 * and pop operations are provided, as well as a method to peek at the top item on the stack, 
 * a method to test for whether the stack is empty, and a method to search the stack for 
 * an item and discover how far it is from the top.
 * 
 * @author Bruce Cloutier
 * @param <E> Entry type
 */

public class Stack<E> extends Vector<E>
{

    /**
     * Creates an empty Stack.
     */
    public Stack()
	{}

    /**
     * Tests if this stack is empty.
     * 
     * @return true if and only if this stack contains no items; false otherwise.
     */
    public boolean empty()
	{}

    /**
     * Looks at the object at the top of this stack without removing it from the stack.
     * 
     * @return the object at the top of this stack (the last item of the Vector object).
     * @throws EmptyStackException if this stack is empty.
     */
    public synchronized E peek() 
            throws EmptyStackException
	{}

    /**
     * Removes the object at the top of this stack and returns that object as the value of this function.
     * 
     * @return The object at the top of this stack (the last item of the Vector object).
     * @throws EmptyStackException if this stack is empty.
     */
    public synchronized E pop()
            throws EmptyStackException
	{}

    /**
     * Pushes an item onto the top of this stack.
     * 
     * @param item the item to be pushed onto this stack.
     * @return the item argument.
     */
    public E push(E item)
	{}

    /**
     *
     * @param obj ?
     * @return ?
     */
    public synchronized int search(Object obj)
	{}
}
