//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2022 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * @author Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/


package com.integpg.comm;

/**
 *
 * @author Bruce Cloutier
 */
public class AUXSerialPort extends SerialPort {

    private static String name = "AUX";
    private static int port = 6;

    /**
     * Class provided access to the AUX serial port.
     */
    public AUXSerialPort() {}

    /**
     * Returns the name of the port.
     * 
     * @return port name
     */
    public static String getName() {}

    /**
     * Sets the state of RTS.
     *
     * @param rts set to true to enable RTS
     * @throws IllegalStateException if the port is not open
     */
    public void setRTS(boolean rts) {}

    private static native void commSetRTS(int port, boolean rts);

    /**
     * Returns the current state of RTS at the exact time it was sampled by the
     * native driver.
     *
     * @return true if RTS is asserted
     * @throws IllegalStateException if the port is not open
     */
    public boolean getRTS() {}

    private static native boolean commGetRTS(int port);

    /**
     * Returns the current state of CTS at the exact time it was sampled by the
     * native driver.
     *
     * @return true if CTS is asserted
     * @throws IllegalStateException if the port is not open
     */
    public boolean getCTS() {}

    private static native boolean commGetCTS(int port);

    /**
     * Sets the driver mode on the AUX serial port for RS-485.
     *
     * @param mode set to true for RS-485 and false for RS-232
     * @throws IllegalStateException if the port is not open
     */
    public void setRS485(boolean mode) {}

    private static native void commSetRS485(int port, boolean mode);

    /**
     * Returns the current driver mode
     *
     * @return true if RS-485 and false if RS-232
     * @throws IllegalStateException if the port is not open
     */
    public boolean getRS485() {}

    private static native boolean commGetRS485(int port);

    /**
     * Sets the slew rate for RS-485 mode.
     *
     * @param fast ?
     *
     * @throws IllegalStateException if the port is not open
     */
    public void setFastSlew(boolean fast) {}

    /**
     * Returns the current state of the RS-485 slew control
     *
     * @return true if fast Slew selected
     *
     * @throws IllegalStateException if the port is not open
     */
    public boolean getFastSlew() {}

    /**
     * Enabled output drivers
     *
     * @param mode set to true to enable drivers
     *
     * @throws IllegalStateException if the port is not open
     */
    public void enableDrivers(boolean mode) {}

    private static native void commEnableDrivers(int port, boolean mode);

    /**
     * Returns the current driver mode
     *
     * @return true if drivers enabled
     *
     * @throws IllegalStateException if the port is not open
     */
    public boolean getDriversEnabled() {}

    private static native boolean commGetDriversEnabled(int port);

    /**
     * Enabled receivers
     *
     * @param mode set to true to enable receivers
     *
     * @throws IllegalStateException if the port is not open
     */
    public void enableReceivers(boolean mode) {}

    private static native void commEnableReceivers(int port, boolean mode);

    /**
     * Returns the current receiver mode
     *
     * @return true if receivers enabled
     *
     * @throws IllegalStateException if the port is not open
     */
    public boolean getReceiversEnabled() {}

    private static native boolean commGetReceiversEnabled(int port);

    /**
     * First this method creates a Break condition on the serial line for a duration defined in 
     * microseconds. Immediately following that a Marking condition also defined in microseconds is
     * inserted. This does not sleep for the duration of the events.
     *
     * @param brk desired duration of the break condition in microseconds. 
     * @param mrk desired duration of the marking condition in microseconds. 
     *
     * @throws IllegalStateException if the port is not open
     */
    public void sendMarkAfterBreak(int brk, int mrk) {}
    
    private static native void commMarkAfterBreak(int handle, int brk, int mak);
    
    /**
     * Captures data following the next Break condition. Method blocks until the required data is 
     *  obtained.
     * 
     * @param buffer filled with data.
     */
    public void readAfterBreak(byte[] buffer) {}
    
    private static native void captureAfterBreak(byte[] bufr);
    
}
