/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package java.util.regex;

/**
 *
 * @author Bruce
 */
public interface MatchResult {
    
    /**
     * Returns the offset of the last character matched.
     * 
     * @return offset The offset after the last character matched
     * @throws IllegalStateException If no match has yet been attempted, or if the previous match operation failed
     */
    public int end() throws IllegalStateException;
    
    /**
     * Returns the offset after the last character of the subsequence captured by
     * the given group during this match.
     * 
     * @param group The index of a capturing group in this matcher's pattern
     * @return The offset after the last character captured by the group, or -1 if the match was successful but the group itself did not match anything
     * @throws IndexOutOfBoundsException If there is no capturing group in the pattern with the given index
     * @throws IllegalStateException If no match has yet been attempted, or if the previous match operation failed
     */
    public int end(int group) throws IndexOutOfBoundsException, IllegalStateException;
    
    /**
     * Returns the input subsequence matched by the previous match.
     * 
     * @return The (possibly empty) subsequence matched by the previous match, in string form
     */
    public String group();
    
    /**
     * Returns the input subsequence captured by the given group during the previous
     * match operation.
     * 
     * @param group The index of a capturing group in this matcher's pattern
     * @return The (possibly empty) subsequence captured by the group during the previous match, or null if the group failed to match part of the input
     */
    public String group(int group);
    
    /**
     * Returns the number of capturing groups in the matched results pattern.
     * 
     * @return The number of capturing groups in this matcher's pattern
     */
    public int groupCount();
    
    /**
     * Returns the start index of the match.
     * 
     * @return The index of the first character matched
     * @throws IllegalStateException If no match has yet been attempted, or if the previous match operation failed
     */
    public int start() throws IllegalStateException;
    
    /**
     * Returns the start index of the subsequence captured by the given group during
     * this match.
     * 
     * @param group The index of a capturing group in this matcher's pattern
     * @return The index of the first character captured by the group, or -1 if the match was successful but the group itself did not match anything
     * @throws IndexOutOfBoundsException If there is no capturing group in the pattern with the given index
     * @throws IllegalStateException If no match has yet been attempted, or if the previous match operation failed
     */
    public int start(int group) throws IndexOutOfBoundsException, IllegalStateException;    
    
}
