package java.net;

import com.integpg.system.ArrayUtils;
import java.io.*;

// Referenced classes of package java.net:
//			SocketImpl, BindException, Inet6Address, InetAddress, 
//			SocketException, SocketInputStream, SocketOptions, SocketOutputStream, 
//			UnknownHostException
class PlainSocketImpl extends SocketImpl {

    public static final String socksDefaultPortStr = "1080";
    public static final String socksPortProp = "socksProxyPort";
    public static final String socksServerProp = "socksProxyHost";

    PlainSocketImpl() {}

    @Override
    protected synchronized void accept(SocketImpl socketimpl)
            throws IOException {}

    private static native int socketAccept(int sock);

    private static native int socketGetRemoteAddr(int sock);

    private static native int socketGetRemotePort(int sock);

    @Override
    protected synchronized int available()
            throws IOException {}

    private static native int socketAvailable(int sock)
            throws SocketException;

    /**
     * Sets the remote address and port for the current socket.
     *
     * @param inetaddress IP address for the remote connection. If null a
     * 0.0.0.0 address is used.
     * @param port The port for the remote connection. If 0 a random port will
     * be assigned.
     */
    @Override
    protected synchronized void bind(InetAddress inetaddress, int port) {}

    private static native int socketBind(int sock, int addr, int port);

    private static native void socketSetRemote(int sock, int addr, int port);

    @Override
    protected void close()
            throws IOException {}

    private static native void socketClose(int sock);

    @Override
    protected void connect(String s, int i)
            throws UnknownHostException, IOException {}

    @Override
    protected void connect(InetAddress inetaddress, int port)
            throws IOException {}

    private static native void socketConnect(int sock, int addr, int port);

    private static native int socketGetLocalPort(int sock);

    /**
     * Allocates a socket table entry.
     *
     * @param stream Flag if TRUE indicating a TCP connection vs. a UDP socket
     * @throws IOException Thrown if the socket table is full.
     */
    @Override
    protected synchronized void create(boolean stream)
            throws IOException {}

    private static native int socketOpen(int port, int addr, boolean stream);

    @Override
    protected void finalize()
            throws IOException {}

    @Override
    protected synchronized InputStream getInputStream()
            throws IOException {}

    @Override
    public Object getOption(int i)
            throws SocketException {}

    @Override
    protected synchronized OutputStream getOutputStream()
            throws IOException {}

    /**
     * Get the SoTimeout
     *
     * @return SoTimeout setting in milliseconds.
     */
    @Override
    public int getSoTimeout() {}

    /**
     * Set SoTimeout for the socket.
     *
     * @param to Timeout in milliseconds.
     * @throws SocketException when the timeout is not set. Typically if the
     * socketId is invalid.
     */
    @Override
    public void setSoTimeout(int to)
            throws SocketException {}

    @Override
    public void setSecure(boolean negotiate)
            throws SocketException {}

    @Override
    public void setServerName(String server)
            throws SocketException {}

    private static native int socketSecure(int sock, boolean nego);

    private static native void socketSetServerName(int sock, String server);

    private static native int socketGetSoTimeout(int sock);

    private static native void socketSetSoTimeout(int sock, int timeout);

    @Override
    public byte[] getCertificate() {}

    private static native byte[] socketCert(int sock);

    @Override
    int getSoLinger()
            throws SocketException {}

    @Override
    void setSoLinger(int to)
            throws SocketException {}

    private static native int socketGetSoLinger(int sock);

    private static native void socketSetSoLinger(int sock, int timeout);

    @Override
    boolean getTcpNoDelay()
            throws SocketException {}

    @Override
    void setTcpNoDelay(boolean flag)
            throws SocketException {}

    private static native boolean socketGetTcpNoDelay(int sock);

    private static native void socketSetTcpNoDelay(int sock, boolean flag);

    @Override
    boolean getKeepAlive()
            throws SocketException {}

    @Override
    void setKeepAlive(boolean flag)
            throws SocketException {}

    private static native boolean socketGetKeepAlive(int sock);

    private static native void socketSetKeepAlive(int sock, boolean flag);

    @Override
    int getSocketId() {}

    private static native byte[] getsockoptNative(int i, int j, int k, byte abyte0[], byte abyte1[])
            throws SocketException;

    @Override
    protected synchronized void listen(int nqueue)
            throws IOException {}

    @Override
    public void setOption(int i, Object obj)
            throws SocketException {}

    private static native byte[] setsockoptNative(int i, int j, int k, byte abyte0[], int l)
            throws SocketException;

    private static native void socketListen(int sock, int nqueue)
            throws SocketException;

}
