package java.lang;

/**
 *
 * @author Bruce
 */
public final class Double extends Number {

    /**
     * POSITIVE_INFINITY
     */
    public static final double POSITIVE_INFINITY = (1.0D / 0.0D);

    /**
     * NEGATIVE_INFINITY
     */
    public static final double NEGATIVE_INFINITY = (-1.0D / 0.0D);

    /**
     * NaN
     */
    public static final double NaN = (0.0D / 0.0D);

    /**
     * MAX_VALUE
     */
    public static final double MAX_VALUE = 1.7976931348623157E+308D;

    /**
     * MIN_VALUE
     */
    public static final double MIN_VALUE = 4.9406564584124654E-324D;
    
    /**
     * TYPE Primitive class type for double
     */
    public static final Class TYPE = Class.getPrimitiveClass("double");
	
    private double value;
	private static double exp_factory[] = new double[0];

    /**
     * Instantiates a Double object with the provided double value.
     * 
     * @param dbl value for the object
     */
    public Double(double dbl) {}

    /**
     * Instantiates a Double object with a value parsed from a string.
     * 
     * @param str Character representation of a numeric value
     * @throws NumberFormatException if the string cannot be parsed
     */
    public Double(String str) throws NumberFormatException {}

    /**
     * Returns the byte value. The double value associated with this obtain is converted to an integer and taken
     * modulo 256.
     * 
     * @return byte value
     */
    public byte byteValue() {}

    /**
     * Returns a long value containing the bit pattern matching the supplied double value. Numerically there is no
     * mathematical relationship between the values. This is useful in packing double values into byte arrays as 
     * would be required perhaps for communications. I can be used to manually interpret IEEE 754 Floating 
     * Point double values.
     * 
     * @param dblval supplied double value
     * @return a long value with matching internal bitwise representation
     */
    public static native long doubleToLongBits(double dblval);

    /**
     * Returns the double value associated with this object.
     * 
     * @return this double value
     */
    public double doubleValue() {}

	public boolean equals(Object obj) {}

    public float floatValue() {}

	public int hashCode() {}

	private static void initExpFactory() {}

    public int intValue() {}

	private static double internalValueOf(String s) throws NumberFormatException {}
