/*---------------------------------------------------------------------------
 * Copyright (C) 2001 Dallas Semiconductor Corporation, All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Dallas Semiconductor
 * shall not be used except as stated in the Dallas Semiconductor
 * Branding Policy.
 *---------------------------------------------------------------------------
 */

package com.integpg.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;

/**
 * <p>The Tools class provides access to methods used by reflection, serialization, and
 * dynamic class loading.  Most applications should probably not use these methods
 * directly, but should instead go through the API's intended for reflection, serialization,
 * and class loading use.
 * 
 * <p>Note an important distinction when using this class--that between method numbers and method
 * table indices.  A method number starts at 0 with methods in the class object and is not
 * repeated in subclasses, except when a method is overridden.  Method numbers are used to 
 * invoke methods.  Method table indices start at 0 within each class and refer only to methods declared
 * by that class.  Reflection information is stored by method table index.  Use the method 
 * <code>getMethodPrimitive(int,int,int)</code> to translate from method table index to method number.
 *
 * @see #getMethodPrimitive(int,int,int)
 *
 * @version    0.00, 19 November 2001
 */
public class Tools 
{
    /**
     * Class number for the class <code>java.lang.Cloneable</code>.  Storage here allows
     * quick access routines without the penalty of searching the firmware for the class number.
     */     
    public static final int cloneableClassNum      = getClassNumber("java.lang.Cloneable");

    /**
     * Class number for the class <code>java.io.Serializable</code>.  Storage here allows
     * quick access routines without the penalty of searching the firmware for the class number.
     */     
    public static final int serializableClassNum   = getClassNumber("java.io.Serializable");

    /**
     * Class number for the class <code>java.io.Externalizable</code>.  Storage here allows
     * quick access routines without the penalty of searching the firmware for the class number.
     */     
    public static final int externalizableClassNum = getClassNumber("java.io.Externalizable");

    /**
     * Class number for the class <code>java.lang.String</code>.  Storage here allows
     * quick access routines without the penalty of searching the firmware for the class number.
     */     
    public static final int stringClassNum = getClassNumber("java.lang.String");


    // no!  bad doggy! never create a new Tools instance!
    private Tools(){};
	
	/** Constant for the bytecode interpreter */
	public static final int OBJ_TYPE_MGC     = 0x34;
	/** Constant for the bytecode interpreter */
	public static final int ARR_TYPE_MGC     = 0xC9;
	/** Constant for the bytecode interpreter */
	public static final int REF_ARR_TYPE_MGC = 0xD5;
	/** Constant for the bytecode interpreter */
	public static final int PRIM_TYPE_MGC    = 0x8B;

	/** Does anyone use this? If so, call NSK at ... */	
	public static final int REFLECT_CLASS_FLAG =            0x80;
	/** Does anyone use this? If so, call NSK at ... */
	public static final int REFLECT_INTERFACE_FLAG =        0x40;
	/** Does anyone use this? If so, call NSK at ... */
	public static final int REFLECT_PRIM_ARRAY_FLAG =       0x20;
	/** Does anyone use this? If so, call NSK at ... */	
	public static final int REFLECT_OBJ_ARRAY_FLAG =        0x10;

	/** Parameter to array_set */	
	public static final int ARRAY_SET_BYTE=0;
	/** Parameter to array_set */	
	public static final int ARRAY_SET_SHORT=1;
	/** Parameter to array_set */	
	public static final int ARRAY_SET_INT=2;
	/** Parameter to array_set */	
	public static final int ARRAY_SET_OBJECT=3;
	/** Parameter to array_set */	
	public static final int ARRAY_SET_LONG=4;
	/** Parameter to array_set */	
	public static final int ARRAY_GET_BYTE=5;
	/** Parameter to array_set */	
	public static final int ARRAY_GET_SHORT=6;
	/** Parameter to array_set */	
	public static final int ARRAY_GET_INT=7;
	/** Parameter to array_set */	
	public static final int ARRAY_GET_LONG=8;
	/** Parameter to array_set */	
	public static final int ARRAY_GET_TAG=9;
	/** Parameter to array_set */	
	public static final int ARRAY_GET_LENGTH=10;
	/** Parameter to array_set */	
	public static final int ARRAY_GET_CLASS_TYPE=11;
	/** Parameter to array_set */
	public static final int ARRAY_GET_DIM=12;

    /**
     * Returns the number of methods in the class represented by <code>classnum</code>.
     *               		
     * @param classnum class number to count methods of
     *
     * @return number of methods in the class, or -1 if the class number is invalid
     */	
    public static native int getMethodCount(int classnum);

    /**
     * Returns the number of static and instance fields in the class
     * represented by <code>classnum</code>.
     * 
     * @param classnum class number to count the fields in
     * 
     * @return number of static and instance fields in the class, or -1
     *         if the class number is invalid
     */
    public static native int getFieldCount(int classnum);

    /**
     * Returns the name of the class from its class number.
     *
     * @param classnum class number to get the name from
     *
     * @return the name of the class (i.e. <code>java.lang.String</code>)
     *         or <code>null</code> if the class number is invalid
     */
    public static native String getClassNameFromNum(int classnum);

	/**
	 * Returns the <code>java.lang.Class</code> object created when
	 * running the static initializer of a class.  If the <code>Class</code>
	 * object does not exist, a new <code>Class</code> object is created, 
	 * though the class is not initialized.
	 * 
	 * @param classNumber class number to retrieve the <code>Class</code> object for
	 *
	 * @return <code>Class</code> object representing the class that this class
	 *         number belongs to, or <code>null</code> if the class number
	 *         is invalid
	 */
	public static native Class getStoredClass(int classNumber);
	
	/* Runs the static initializer for the class represented by 
	 * <code>classnumber</code>, if it has not yet run.  Note that
	 * this may cause other static initializers to run, as described
	 * in the Java Virtual Machine Specification.
	 *
	 * @param classnumber class to run the static initializer of
	 *
	 * @return return code of the bytecode interpreter (0 for success,
	 *         non-zero represents a failure)
	 */

    /**
     *
     * @param classnumber ?
     * @return ?
     */
    
	public static native int runInitializer(int classnumber);

	/**
	 * Returns the class number of the object. Hopefully this method will be 
	 * renamed before anyone ever sees this. 
	 *	
     *
	 * @param o Class being queried
     * @return  ?
	 */
	public static native int getDaClassNumber(Object o);

	/**
		Returns the class number of the class obj. 

		@param cl Class object being queried
     * @return  ?
	*/
	public static native int getClassNumberFromClass(Class cl);
	
	//these are duplicates from Class class, we can probably just move them here

	/**
		Maps a class name to a class number.
		@param className String name of class (e.g java.lang.String)
     * @return  ?
	*/
	public static native int getClassNumber(String className);

    /**
     * Returns the class number of the superclass of the class represented by
     * <code>classNum</code>.
     *
     * @param classNum ?
     *
     * @return class number of <code>classNum</code>'s superclass, 
     *         or <code>-1</code> if the class has no superclass
     *
     * @throws IllegalArgumentException if the class number is invalid
     */
    public static native int getSuperclassNumber(int classNum);

    /** 
     * Gets the access flags for a class.  Access flags are described in 
     * the Java Virtual Machine Specification section 4.1.
     *
     * @param classNumber ?
     * 
     * @return Java class access flags, or 0xFFFF (65535) if the
     *         class number is invalid
     */
    public static native int getAccessFlags (int classNumber);


	//
	// NSK - I'd like to go on record right now to say that the field
	// interface is pure krap, and I will be changing it shortly.
	//

	/**
		setFieldXXX sets the value inside a field. This one is kind of embarrasing - 
		setFieldValue, setObjectFieldValue, and
		setWideFieldValue all do the SAME THING (The same code is called for all
		three, etc). What is up with index coming before classnum, unlike everythin
		else? Sad, really. I must have written this while I was high on... caffene.
		No error checking is done
		on type (because I do it in java.lang.reflect.Field), so you better 
		set it to a valid value. The only difference is for setting a regular value,
		an object value, or a wide value.
		@param O Object who'se field is to be set
		@param index index of field to be set
		@param classnum class number of field to be set. Allows for setting
				of superclass numbers
		@param value Value to assign field.
	*/
	public static native void setFieldValue(Object O, int index, int classnum, int value);
	/**
		setFieldXXX sets the value inside a field. This one is kind of embarrasing - 
		setFieldValue, setObjectFieldValue, and
		setWideFieldValue all do the SAME THING (The same code is called for all
		three, etc). What is up with index coming before classnum, unlike everythin
		else? Sad, really. I must have written this while I was high on... caffene.
		No error checking is done
		on type (because I do it in java.lang.reflect.Field), so you better 
		set it to a valid value. The only difference is for setting a regular value,
		an object value, or a wide value.
		@param O Object who'se field is to be set
		@param index index of field to be set
		@param classnum class number of field to be set. Allows for setting
				of superclass numbers
		@param value Value to assign field.
	*/
	
	public static native void setObjectFieldValue(Object O, int index, int classnum, Object value);
	
	/**
		setFieldXXX sets the value inside a field. This one is kind of embarrasing - 
		setFieldValue, setObjectFieldValue, and
		setWideFieldValue all do the SAME THING (The same code is called for all
		three, etc). What is up with index coming before classnum, unlike everythin
		else? Sad, really. I must have written this while I was high on... caffene.
		No error checking is done
		on type (because I do it in java.lang.reflect.Field), so you better 
		set it to a valid value. The only difference is for setting a regular value,
		an object value, or a wide value.
		@param O Object who'se field is to be set
		@param index index of field to be set
		@param classnum class number of field to be set. Allows for setting
				of superclass numbers
		@param value Value to assign field.
	*/

	public static native void setWideFieldValue(Object O, int index, int classnum, long value);
	
	/**
		getFieldValue, getFieldObjectValue, and getWideFieldValue
		also all do the same thing - get values from fields. Oh the embarrasment... 
		My same objections apply to this one as well.
		Once again doesn't do any type checking
		So don't be getting any object of int values.
	
		@param O Object whose field is to be queried
		@param index index of field to be queried
		@param classnum classnum of field to be set. 
     * @return   ?

	*/
	public static native int getFieldValue(Object O, int index, int classnum);
	/**
		getFieldValue, getFieldObjectValue, and getWideFieldValue
		also all do the same thing - get values from fields. Oh the embarrasment... 
		My same objections apply to this one as well.
		Once again doesn't do any type checking
		So don't be getting any object of int values.
	
		@param O Object whose field is to be queried
		@param index index of field to be queried
		@param classnum classnum of field to be set. 

	*/

    /**
     * getFieldValue, getFieldObjectValue, and getWideFieldValue
		also all do the same thing - get values from fields.Oh the embarrasment... 
		My same objections apply to this one as well.
		Once again doesn't do any type checking
		So don't be getting any object of int values.
     * @param O Object whose field is to be queried
     * @param index index of field to be queried
     * @param classnum classnum of field to be set.
     * @return ?
     */
    public static native Object getObjectFieldValue(Object O, int index, int classnum);
	/**
		getFieldValue, getFieldObjectValue, and getWideFieldValue
		also all do the same thing - get values from fields. Oh the embarrasment... 
		My same objections apply to this one as well.
		Once again doesn't do any type checking
		So don't be getting any object of int values.
	
		@param O Object whose field is to be queried
		@param index index of field to be queried
		@param classnum classnum of field to be set. 

	*/

    /**
     * getFieldValue, getFieldObjectValue, and getWideFieldValue
		also all do the same thing - get values from fields.Oh the embarrasment... 
		My same objections apply to this one as well.
		Once again doesn't do any type checking
		So don't be getting any object of int values.
     * @param O Object whose field is to be queried
     * @param index index of field to be queried
     * @param classnum classnum of field to be set.
     * @return ?
     */
    public static native long getWideFieldValue(Object O, int index, int classnum);

	/**
		getFieldString gets the name string
		of a field from the trash heap. I like how I did methods better. 
		@param classnum class number of object
		@param index index into field table
     * @return  ?

	*/
	public static native String getFieldString(int classnum, int index);

    /**
     * @param classnum class number of object
     * @param index index into field table
     * @return  ?
     * 
	 */
	public static native int getFieldType(int classnum, int index);
	/**
		getModifers0 returns the modifiers for a given field
		@param classnum class number of object
		@param index index into field table
     * @return  ?
	*/
	public static native int getModifiers0(int classnum, int index);


	/**
     * Method info getter. The query parameter is an actual
     * index into the method record, which allows these methods to be used 
     * as more info is stored there. Here's how to get the info out.
     * 
     * @param classnum class number of object
     * @param index index into method table
     * @param query index into method entry	
     * @return 	 ?
     * 
	 */
	public static native String getMethodString(int classnum, int index, int query);
	/**
		Method info getter. The query parameter is an actual
		index into the method record, which allows these methods to be used 
		as more info is stored there. Here's how to get the info out.<br>
		<table border=1>
		<tr><td><b>Name</b></td><td>getMethodString(cnum,index,0);</td></tr>
		<tr><td><b>Descriptor</b></td><td>getMethodByteArray(cnum,index,1);</td></tr>
		<tr><td><b>Method Number</b></td><td>getMethodPrimitive(cnum,index,2);</td></tr>
		<tr><td><b>Modifiers</b></td><td>getMethodPrimitive(cnum,index,3); (low byte only)</td></tr>
		</table>
		@param classnum class number of object
		@param index index into method table
		@param query index into method entry	

	*/

    /**
     * Method info getter.The query parameter is an actual
		index into the method record, which allows these methods to be used 
		as more info is stored there. Here's how to get the info out.<br>
     * @param clasnum class number of object
     * @param index index into method table
     * @param query index into method entry
     * @return  ?
     */
    public static native int getMethodPrimitive(int clasnum, int index, int query);
	/**
		Method info getter. The query parameter is an actual
		index into the method record, which allows these methods to be used 
		as more info is stored there. Here's how to get the info out.<br>
		<table border=1>
		<tr><td><b>Name</b></td><td>getMethodString(cnum,index,0);</td></tr>
		<tr><td><b>Descriptor</b></td><td>getMethodByteArray(cnum,index,1);</td></tr>
		<tr><td><b>Method Number</b></td><td>getMethodPrimitive(cnum,index,2);</td></tr>
		<tr><td><b>Modifiers</b></td><td>getMethodPrimitive(cnum,index,3); (low byte only)</td></tr>
		</table>
		@param classnum class number of object
		@param index index into method table
		@param query index into method entry	

	*/

    /**
     * Method info getter.The query parameter is an actual
		index into the method record, which allows these methods to be used 
		as more info is stored there. Here's how to get the info out.<br>
     * @param classnum class number of object
     * @param index index into method table
     * @param query index into method entry
     * @return ?
     */
    public static native byte [] getMethodByteArray(int classnum, int index, int query);


	/**
		Dynamically runs a method. Invoke is a deadly method if used wrong, which is why 
		I highly recommend using it from the Method class. 
	
		@param classnum class number of object
		@param methodnum NOT TO BE CONFUSED WITH METHOD INDEX. The method number of the method (queried with getMethodPrimitive.
		@param args Array of four byte values. All primitives must be converted to their primitive representation (Float.floatToIntBits, etc), all objects must be turned into ints (Tools.obj2long(...)).
     * @return  ?

	*/
	public static native long invoke0(int classnum, int methodnum, int [] args);

	/**
		findMethodByName finds the index of a method using it's string name. For example<br>
		<br>
		<code>mIndex = Tools.findMethodByName(PrintStreamNum,\"println(Ljava.lang.String;)V\");</code><br>
		<br>
		@param classnum class number to search
		@param compare String name of method
     * @return  ?
	*/
	public static native short findMethodByName(int classnum, String compare);

	/**
		findMethodByName2 finds method info on a specified method
		@param classnum class number to search
		@param compare String name of method
		@return Low word is methodnum, high word is access flags (in my packed form)	
	*/
	public static native int findMethodByName2(int classnum, String compare);
	/**
		findFieldByName finds the index of a field using it's string name. For example<br>
		<br>
		<code>fIndex = Tools.findFieldByName(IntegerCnum,\"TYPE\");</code><br>	
		<br>
		@param classnum class number to search
		@param compare String name of field 
	*/

    /**
     * findFieldByName finds the index of a field using it's string name.For example<br>
		<br>
		<code>fIndex = Tools.findFieldByName(IntegerCnum,\"TYPE\");</code><br>	
		<br>
     * @param classnum class number to search
     * @param compare String name of field
     * @return ?
     */
    public static native short findFieldByName(int classnum, String compare);

	/**
		findFieldByName2 finds field info on a specified field
		@param classnum class number to search
		@param compare String name of method
		@return Low byte is fieldnum, Second byte is access flags
	*/
	public static native short findFieldByName2(int classnum, String compare);
	/**
		findMethodByIndex finds the index of a method using an entry from a stacktrace
		dump. 
		@param value entry from a stack trace dump
     * @return  ?
	*/
	public static native short findMethodByIndex(int value);

	/**
		getField/Method/ConstructorClass all return the appropriate class represented
		by the index/classnum pair. There's that stupid index/classnum parameter 
		mixup again! I must have been smokin' some serious... caffene.
		@param index index into field/method table
		@param classnum class number of object
     * @return  ?
	*/
	public static native Field getFieldClass(int index, int classnum);
		/**
		getField/Method/ConstructorClass all return the appropriate class represented
		by the index/classnum pair. There's that stupid index/classnum parameter 
		mixup again! I must have been smokin' some serious... caffene.
		@param index index into field/method table
		@param classnum class number of object
	*/

    /**
     * getField/Method/ConstructorClass all return the appropriate class represented
		by the index/classnum pair.There's that stupid index/classnum parameter 
		mixup again! I must have been smokin' some serious... caffene.
     * @param index index into field/method table
     * @param classnum class number of object
     * @return ?
     */
    public static native Method getMethodClass(int index, int classnum);
	
	/**
		getField/Method/ConstructorClass all return the appropriate class represented
		by the index/classnum pair. There's that stupid index/classnum parameter 
		mixup again! I must have been smokin' some serious... caffene.
		@param index index into field/method table
		@param classnum class number of object
     * @return  ?
	*/

	public static native Constructor getConstructorClass(int index, int classnum);

	/**
		array_set get and sets array info/values. It is basically the array class in 
		one method. Yeah, that's right - fear the power. Objects must be converted
		out of their long form using <code>obj2long</code>
		@param array array to operate on
		@param index index of element in question
		@param flags the following flags are available:<br>
		@param iPrim for setting byte/short/int values
		@param obj for setting object values
		@param lPrim for setting long values
     * @return  ?

	*/

	public static native long array_set(Object array, int index, int flags, int iPrim, Object obj, long lPrim);

	/**
		Creates a new array of type x. Supports one dimention only.
		@param x Class class of type to be creates 
		@param size Number of elements
     * @return  ?
	*/
	public static native Object arrayNewInstance(Class x, int size);

    /**
     * help me!!! i need javadocs!!!
     * @param x ?
     * @param size ?
     * @return  ?
     */
	public static native Object arrayNewInstance2(Class x, int[] size);

	/**
		Convers an object to a primitive for good casting.
		@param x Object to change.
     * @return  ?
	*/
	public static native long obj2long(Object x);
	/**
		long2obj convers a long return value into the object it came from.
		@param x object in long clothing
     * @return  ?
	*/
	public static native Object long2obj(long x);

	/**
		Creates an object (but does not run it's constructor). Used in Serialization.
		@param s Class class of object to create. Do not feed a primitive class.
     * @return  ?
	*/
	public static native Object allocateClass(Class s);

	/**
		Traces the java stack for methods. Use findMethodByIndex to get 
		method indicies for each entry. Returns the number of elements filled
		@param bt int array - must be at least 64 entries long.
     * @return  ?
	*/
	public static native int getStackTrace(int []bt);
	
    /**
     * Get the class numbers of the declared interfaces of this class.
     *
     *
     * @param classNum ?
     * @return array of class numbers representing declared interfaces
     *
     * @throws IllegalArgumentException if the class number is invalid
     */
    public static native int[] getInterfacesNative (int classNum);

	/**
		Maps an interface number to the methodnumber that
		implements it. Used for late binding of interface
		methods to their class counterparts
		@param classnum Classnumber of object
		@param inum Interface method hash code
     * @return  ?
	*/

	public static native int inum2mnum(int classnum, int inum);

	/**
		String compare for Method strings. Uses strings
		in the form of <code>method:(II)Ljava/lang/String;</code>
		and does a string compare on them.
		@param str1 first method string
		@param str2 second method string
		@return -1 if str1 &lt; str2, 0 if str1 == str2, 1 if str1 &gt; str2
	*/
	public static native int strcmpM(String str1, String str2);
	/**
		String compare for field strings. Uses strings
		in the form of <code>field:Ljava.lang.Object;</code>
		and does a string compare on them. Ignores everything
		after a colon.
		@param str1 first field strig
		@param str2 second field string
		@return -1 if str1 &lt; str2, 0 if str1 == str2, 1 if str1 &gt; str2,
	*/

    public static native int strcmpF(String str1, String str2);

	
    /**
     * help me!!! i need javadocs!!!
     * @param classnum ?
     * @param index ?
     * @return  ?
     */
    public static String getMethodName(int classnum, int index)
    {}

    /**
     * Returns the descriptor string of a method in String format. For example, 
     * the arguments for <code>void Float.intBitsToFloat(int)</code> would return <b>(I)V</b>. 	
     *
     * @param classnum class number to query
     * @param index index of method in method table
     *
     * @return method descriptor string
     */
    public static String getFullMethodDescriptor(int classnum, int index)
    {}

    /**
     * help me!!! i need javadocs!!!
     * @param classnum ?
     * @param index ?
     * @return  ?
     */
    public static String getFieldName(int classnum, int index)
    {}
    	
    /**
     * help me!!! i need javadocs!!!
     * @param prim ?
     * @return  ?
     */
    public static char prim2char(int prim)
    {}


    /**
     * help me!!! i need javadocs!!!
     * @param prim ?
     * @return  ?
     */
    public static Class prim2class(int prim)
    {}	
    	
	/**
	 * <p>Marks a class to be findable by the <code>Class.forName(java.lang.String)</code> method.
	 * This function is only useful when <code>cnum</code> refers to a dynamically loaded class.
	 * This allows us to dynamically load some classes through the <code>forName</code> method,
	 * but also solve the name-space issue, since classes loaded by any other class loader
	 * will not be findable by <code>forName</code>.  </p>
	 *
	 * <p>This behavior makes our primordial class loader a little schizophrenic--the 'primordial'
	 * class loader is actually the primordial class loader plus a 'File System' class loader
	 * with special powers.  This behavior may change in future releases.</p>
	 *
	 * @param cnum class number to mark as 'findable'
	 *
	 */
	public static native void markClassFindable(int cnum);

    /*
     * Determines if a class (classNum) or its superclass implememts an 
     * interface (interfaceClassNum).
     */

    /**
     *
     * @param classNum ?
     * @param interfaceClassNum ?
     * @return ?
     */
    
    public static native boolean isInterfaceAssignableFrom(int classNum, int interfaceClassNum);					

    /*
     * Creates a Class Class. It's magically delicious!
     */

    /**
     *
     * @param magicNum ?
     * @param type ?
     * @param componentType ?
     * @return ?
     */
    
    public static native Class createClassClass(int magicNum, int type, int componentType);
}






