/*
 * @(#)DecimalFormatSymbols.java	1.18 01/12/10
 *
 * (C) Copyright Taligent, Inc. 1996 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - All Rights Reserved
 *
 * Portions copyright (c) 2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 *   The original version of this source code and documentation is copyrighted
 * and owned by Taligent, Inc., a wholly-owned subsidiary of IBM. These
 * materials are provided under terms of a License Agreement between Taligent
 * and Sun. This technology is protected by multiple US and International
 * patents. This notice and attribution to Taligent may not be removed.
 *   Taligent is a registered trademark of Taligent, Inc.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
package java.text;

import java.util.Locale;

/**
 * This class represents the set of symbols (such as the decimal separator, the grouping separator, and so on) needed by
 * <code>DecimalFormat</code> to format numbers. <code>DecimalFormat</code> creates for itself an instance of
 * <code>DecimalFormatSymbols</code> from its locale data. If you need to change any of these symbols, you can get the
 * <code>DecimalFormatSymbols</code> object from your <code>DecimalFormat</code> and modify it.
 *
 * @see java.util.Locale
 * @see DecimalFormat
 * @version 1.12 29 Jan 1997
 * @author Mark Davis
 * @author Alan Liu
 */
final public class DecimalFormatSymbols implements Cloneable {

    /**
     * Create a DecimalFormatSymbols object for the default locale.
     */
    public DecimalFormatSymbols() {}

    /**
     * Create a DecimalFormatSymbols object for the given locale.
     * @param locale locale
     */
    public DecimalFormatSymbols(Locale locale) {}

    /**
     * Gets character used for zero.
     * 
     * @return the character
     */
    public char getZeroDigit() {}

    /**
     * Sets character used for zero.
     * 
     * @param zeroDigit zero character
     */
    public void setZeroDigit(char zeroDigit) {}

    /**
     * Get the character used for thousands separator.
     * 
     * @return the character
     */
    public char getGroupingSeparator() {}

    /**
     * Set the character used for thousands separator.
     *
     * @param groupingSeparator the character to use
     */
    public void setGroupingSeparator(char groupingSeparator) {}

    /**
     * Get character used for decimal sign.
     * 
     * @return the character
     */
    public char getDecimalSeparator() {}

    /**
     * Set character used for decimal sign.
     *
     * @param decimalSeparator the character to use
     */
    public void setDecimalSeparator(char decimalSeparator) {}

    /**
     * Get the character used for mille percent sign.
     * 
     * @return the character
     */
    public char getPerMill() {}

    /**
     * Set the character used for mille percent sign.
     *
     * @param perMill the character to use
     */
    public void setPerMill(char perMill) {}

    /**
     * Gets the character used for percent sign.
     * 
     * @return the character
     */
    public char getPercent() {}

    /**
     * Sets the character used for percent sign.
     *
     * @param percent the character to use
     */
    public void setPercent(char percent) {}

    /**
     * Gets the character used for a digit in a pattern.
     * 
     * @return the character
     */
    public char getDigit() {}

    /**
     * Sets the character used for a digit in a pattern.
     *
     * @param digit the character to use
     */
    public void setDigit(char digit) {}

    /**
     * Gets the character used to separate positive and negative subpatterns in a pattern.
     * 
     * @return the character
     */
    public char getPatternSeparator() {}

    /**
     * Sets the character used to separate positive and negative subpatterns in a pattern.
     *
     * @param patternSeparator the character to use
     */
    public void setPatternSeparator(char patternSeparator) {}

    /**
     * Gets the character used to represent infinity.
     * 
     * @return the character
     */
    public String getInfinity() {}

    /**
     * Sets the character used to represent infinity.
     *
     * @param infinity the character to use
     */
    public void setInfinity(String infinity) {}

    /**
     * Gets character used to represent NaN.
     * 
     * @return the character
     */
    public String getNaN() {}

    /**
     * Sets character used to represent NaN.
     *
     * @param NaN the character to use
     */
    public void setNaN(String NaN) {}

    /**
     * Gets the character used to represent minus sign. If no explicit negative format is specified, 
     * one is formed by prefixing minusSign to the positive format.
     * 
     * @return the character
     */
    public char getMinusSign() {}

    /**
     * Sets the character used to represent minus sign.
     *
     * @param minusSign the character to use
     */
    public void setMinusSign(char minusSign) {}

    //------------------------------------------------------------
    // BEGIN   Package Private methods ... to be made public later
    //------------------------------------------------------------
    /**
     * Return the character used to separate the mantissa from the exponent.
     */
    char getExponentialSymbol() {}

    /**
     * Set the character used to separate the mantissa from the exponent.
     */
    void setExponentialSymbol(char exp) {}

    /**
     * Return the string denoting the local currency.
     */
    String getCurrencySymbol() {}

    /**
     * Set the string denoting the local currency.
     */
    void setCurrencySymbol(String currency) {}

    /**
     * Return the international string denoting the local currency.
     */
    String getInternationalCurrencySymbol() {}

    /**
     * Set the international string denoting the local currency.
     */
    void setInternationalCurrencySymbol(String currency) {}

    /**
     * Return the monetary decimal separator.
     */
    char getMonetaryDecimalSeparator() {}

    /**
     * Set the monetary decimal separator.
     */
    void setMonetaryDecimalSeparator(char sep) {}

    //------------------------------------------------------------
    // END     Package Private methods ... to be made public later
    //------------------------------------------------------------
    /**
     * Standard override.
     * 
     * @return the clone
     */
    @Override
    public Object clone() {}

    /**
     * Override equals
     */
    @Override
    public boolean equals(Object obj) {}

    /**
     * Override hashCode
     */
    @Override
    public int hashCode() {}

    /**
     * Initializes the symbols from the LocaleElements resource bundle. Note: The organization of LocaleElements badly needs to
     * be cleaned up.
     */
    private void initialize(Locale locale) {}

    private char zeroDigit;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator; // Field new in JDK 1.1.6
    private char exponential;       // Field new in JDK 1.1.6
}
