App.controller('AppCtrl', function ($scope, $location) {
    _this = this;
    _this.Version = '19.4';

    _this.GrapherConfig = {};
    _this.charts = [];
    _this.selectedChart = null;
    _this.realTime = true;

    var jnrWebsocket = new JnrWebsocket();


    App.init = function () {
        jnrWebsocket.addOnLoggedInListener(function () {
            console.log('logged in');
            getGrapherConfig();
        });

        jnrWebsocket.connect();

        // set up a recurring 15 second timer that will update the chart in real time
        setInterval(function () {
            // update the current selected graph only
            // for each file config used by this chart we need to get the current data
            var graphConfig = _this.selectedChart;
            graphConfig.fileConfigurations.forEach(function (fileConfig) {
                _this.getDataFileForDate(fileConfig, new Date());
            });
        }, 15000);
    };



    _this.setSelectedChart = function (graphConfig) {
        _this.selectedChart = graphConfig;
    };



    _this.selectStart = function () {
        $('#datepicker').datepicker('show');
        $('#datepicker').on('changeDate', function (e) {
            try {
                var graphConfig = _this.selectedChart;
                var chart = graphConfig.chart;
                if (!graphConfig.duration) graphConfig.duration = 4;
                var duration = 3600000 * graphConfig.duration;

                //
                // get the time from the selected date
                var start = e.date.getTime();

                chart.config.options.scales.xAxes[0].time.min = start;
                chart.config.options.scales.xAxes[0].time.max = start + duration;
                chart.update();

                _this.realTime = false;
            } catch (err) { }
            $('#datepicker').datepicker('hide');
        });
    };



    _this.earlier = function (factor) {
        var graphConfig = _this.selectedChart;
        var chart = graphConfig.chart;
        if (!graphConfig.duration) graphConfig.duration = 4;
        var duration = 3600000 * graphConfig.duration;
        var start = chart.config.options.scales.xAxes[0].time.min;
        chart.config.options.scales.xAxes[0].time.min = start - (duration / factor);
        chart.config.options.scales.xAxes[0].time.max = chart.config.options.scales.xAxes[0].time.min + duration;
        chart.update();

        _this.realTime = false;
    };



    _this.later = function (factor) {
        var graphConfig = _this.selectedChart;
        var chart = graphConfig.chart;
        if (!graphConfig.duration) graphConfig.duration = 4;
        var duration = 3600000 * graphConfig.duration;
        var start = chart.config.options.scales.xAxes[0].time.min;
        chart.config.options.scales.xAxes[0].time.min = start + (duration / factor);
        chart.config.options.scales.xAxes[0].time.max = chart.config.options.scales.xAxes[0].time.min + duration;
        chart.update();

        _this.realTime = false;
    };



    _this.now = function () {
        var graphConfig = _this.selectedChart;
        var chart = graphConfig.chart;
        if (!graphConfig.duration) graphConfig.duration = 4;
        var duration = 3600000 * graphConfig.duration;
        var end = new Date().getTime();
        chart.config.options.scales.xAxes[0].time.min = end - duration;
        chart.config.options.scales.xAxes[0].time.max = end;
        chart.update();

        _this.realTime = true;
    };



    _this.setDuration = function () {
        var graphConfig = _this.selectedChart;
        var chart = graphConfig.chart;
        if (!graphConfig.duration) graphConfig.duration = 4;
        var duration = 3600000 * graphConfig.duration;
        var end = chart.config.options.scales.xAxes[0].time.max;
        chart.config.options.scales.xAxes[0].time.min = end - duration;
        chart.update();
    };



    _this.isCurrent = function () {
        var graphConfig = _this.selectedChart;
        var chart = graphConfig.chart;
        var endTime = chart.config.options.scales.xAxes[0].time.max;
        var now = new Date().getTime();
        return endTime >= now;
    };



    function getGrapherConfig() {
        var CONFIG_FILE_NAME = '/flash/grapher.json';
        jnrWebsocket.readFile(CONFIG_FILE_NAME, function (response) {
            console.log('readFile status for ' + response.File + ': ' + response.Status);
            if ('Fail' !== response.Status) {
                var fileContents = Base64.decode(response.Data);
                _this.GrapherConfig = JSON.parse(fileContents);
                console.log('config: ' + JSON.stringify(_this.GrapherConfig, null, 2));

                if (_this.GrapherConfig.Title) {
                    document.title = _this.GrapherConfig.Title;
                }

                // getDataFiles();
                createCharts();

                $scope.$apply();
            }
        });
    }



    _this.getDataFileForDate = function (fileConfig, date) {
        var filename = "/";
        if (fileConfig.dataFolder && "" !== fileConfig.dataFolder && "/" !== fileConfig.dataFolder)
            filename += fileConfig.dataFolder + "/";
        if (fileConfig.name) {
            filename += fileConfig.name;
        }
        if (fileConfig.fileDateFormat && "" !== fileConfig.fileDateFormat)
            filename += "_" + moment(date).format(fileConfig.fileDateFormat);
        if (!filename.endsWith(".csv"))
            filename += '.csv';
        filename = filename.replaceAll('//', '/');

        console.log('filename: ' + filename);

        var myRegexp = /(.*\/)?({{date\((\w+)\)}})+.*/;
        var match = myRegexp.exec(filename);
        if (match && 2 < match.length) {
            var dateReplacePart = match[3];
            var datePart = moment(date).format(dateReplacePart);

            // make sure we have an array of previously loaded date strings
            if (!fileConfig.loadedDates) fileConfig.loadedDates = [];

            // if the date passed in is NOT the current date AND we have already loaded a 
            // file for this date format then abort
            var currentDateString = moment().format(dateReplacePart);
            if (currentDateString != datePart && fileConfig.loadedDates[datePart]) return;

            filename = filename.replace(match[2], datePart);
            console.log(new moment() + ' get ' + filename);

            jnrWebsocket.readFile(filename, function (response) {
                console.log(new moment() + ' readFile status for ' + response.File + ': ' + response.Status);
                if ('Fail' !== response.Status) {
                    var fileContents = Base64.decode(response.Data);
                    // console.log(fileContents);

                    fileConfig.loadedDates[datePart] = true;

                    processFile(fileContents, fileConfig);
                }
            });
        }

        console.log('filename: ' + filename);
    }



    function processFile(fileContents, fileConfig) {
        var start = new Date();

        var lines = fileContents.split("\r\n");
        lines.forEach(function (line) {
            var fields = line.split(",");

            if (2 <= fields.length) {
                var timestamp = moment(fields[0], fileConfig.dateFormat).valueOf();

                for (var i = 1; i < fileConfig.schema.length; i++) {
                    var column = fileConfig.schema[i].trim();
                    var dataset = fileConfig.datasets[column];
                    if (dataset) {
                        // make sure there is not already a datapoint at this timestamp
                        var found = dataset.find(function (datapoint) {
                            return (datapoint.x === timestamp);
                        });

                        if (!found) {
                            var value = null;
                            if ('null' !== fields[i]) {
                                value = parseFloat(fields[i].trim());
                                dataset.push({ x: timestamp, y: value });
                            }
                        }
                    }
                }
            }

        });

        var elapsed = new Date() - start;
        console.log('process file took: ' + elapsed);
        var start = new Date();

        var values = Object.keys(fileConfig.datasets).map(function (e) {
            return fileConfig.datasets[e];
        })

        // Object.values(fileConfig.datasets)
        values.forEach(function (dataset) {
            console.log('dataset.length: ' + dataset.length);
            dataset.sort(function (a, b) {
                return a.x - b.x;
            });
        });

        var elapsed = new Date() - start;
        console.log('sorting took: ' + elapsed);
        var start = new Date();

        // get the chart from our graphConfig object and update it
        var chart = _this.selectedChart.chart;
        chart.update();

        var elapsed = new Date() - start;
        console.log('update took: ' + elapsed);

        //
        // if we are in real time then update the chart to now, the current time
        if (_this.realTime) {
            _this.now();
        }
    }



    function createCharts() {
        // go through each graph config and create the chart for that configuration.
        _this.GrapherConfig.graphs.forEach(function (graphConfig) {
            if (null === _this.selectedChart) {
                _this.setSelectedChart(graphConfig);
            }

            console.log(JSON.stringify(graphConfig, null, 2));
            graphConfig.canvasId = 'canvas-' + graphConfig.chartName.toLowerCase();

            // Go through each dataset and find the file that the graph depends on.  
            // Assign that file config to the graph config so we can update the 
            // graph as needed.  Not there may be more than one file needed, so lets 
            // make sure there is an array for these file configurations.
            if (!graphConfig.fileConfigurations) graphConfig.fileConfigurations = [];

            graphConfig.dataSets.forEach(function (datasetConfig) {
                var fileConfig = _this.GrapherConfig.files.find(function (fileConfig) {
                    for (var i = 1; i < fileConfig.schema.length; i++) {
                        var column = fileConfig.schema[i].trim();
                        if (datasetConfig.ref === column) {
                            return true;
                        }
                    }
                    // if it wasnt found then return false
                    return false;
                });

                if (null !== fileConfig) {
                    // check to see if this file config is already added to our 
                    // graphConfig.fileConfigurations array
                    if (null == graphConfig.fileConfigurations.find(function (tempFileConfig) {
                        return tempFileConfig === fileConfig;
                    })) {
                        // we found a used fileConfig.  Make sure it has a aray for each 
                        // possible data array
                        if (!fileConfig.datasets) fileConfig.datasets = [];
                        for (var i = 1; i < fileConfig.schema.length; i++) {
                            var column = fileConfig.schema[i].trim();
                            if (!fileConfig.datasets[column]) fileConfig.datasets[column] = [];
                        }

                        // we found valid file config.  assign it to our graph config
                        graphConfig.fileConfigurations.push(fileConfig);
                    }
                }
            });
        });
    }
});



App.directive('graph', function () {
    return function (scope, element, attrs) {
        var graphConfig = scope.graphConfig;

        // build an array of datasets that we will add to the chart
        var datasets = [];
        graphConfig.dataSets.forEach(function (datasetConfig) {
            var newDataset = {
                type: 'line',
                label: datasetConfig.label,
                // the data for this dataset will have been created as part of the datafile
                // configuration for this graphConfig
                data: graphConfig.fileConfigurations.find(function (fileConfig) {
                    var dataset = fileConfig.datasets[datasetConfig.ref];
                    return null != dataset;
                }).datasets[datasetConfig.ref],
                backgroundColor: datasetConfig.color,
                borderColor: datasetConfig.color,
                borderWidth: 2,
                fill: false,
                lineTension: 0,
                pointRadius: 1
            };
            datasets.push(newDataset);
            datasetConfig.dataset = newDataset;
        });

        config = {
            type: 'Line',
            data: {
                datasets: datasets
            },
            options: {
                maintainAspectRatio: false,
                animation: {
                    duration: 0
                },
                responsive: true,
                tooltips: {
                    mode: 'nearest',
                    intersect: false,
                    callbacks: {
                        title: function (tooltipItem, data) {
                            var x = data.datasets[tooltipItem[0].datasetIndex].data[tooltipItem[0].index].x;
                            var date = moment(x);
                            return date.format('ll') + ' ' + date.format('h:mm:ss A');
                        }
                    }
                },
                scales: {
                    xAxes: [{
                        type: 'time',
                        time: {
                            max: new Date().getTime(),
                            min: new Date() - (3600000 * (graphConfig.duration || 4)), // 4 hour default
                            unit: 'minute',
                            unitStepSize: 15
                        },
                        gridLines: {
                            borderDash: [6, 2]
                        },
                        ticks: {
                            callback: function (label, index, ticks) {
                                if (0 != ticks.length) {
                                    var prevDate = (0 !== index) ? new Date(ticks[index - 1].value) : null;
                                    var tickDate = new Date(ticks[index].value);
                                    if (prevDate == null || prevDate.getDate() !== tickDate.getDate()) {
                                        label = moment(tickDate).format('ll') + ' ' + label;

                                        if (new Date() > tickDate) {
                                            graphConfig.fileConfigurations.forEach(function (fileConfig) {
                                                var myRegexp = /(.*\/)?({{date\((\w+)\)}})+.*/;
                                                var match = myRegexp.exec(fileConfig.name);
                                                if (match && 2 < match.length) {
                                                    var dateReplacePart = match[3];
                                                    var datePart = moment(tickDate).format(dateReplacePart);

                                                    // make sure we have an array of previously loaded date strings
                                                    if (!fileConfig.loadedDates) fileConfig.loadedDates = [];
                                                    // if we have already loaded a file for this date format then abort
                                                    if (!fileConfig.loadedDates[datePart]) {
                                                        console.log(new moment() + ' get ' + fileConfig.name + ' using ' + datePart);
                                                        _this.getDataFileForDate(fileConfig, tickDate);

                                                        fileConfig.loadedDates[datePart] = true;
                                                    }
                                                }
                                            });

                                        }
                                    }
                                    return label;
                                }
                            }
                        },
                        beforeBuildTicks: function (axis) {
                            var duration = axis.max - axis.min;
                            duration /= 1000;
                            if ((3600 * 24 * 7) < duration) {
                                axis.options.time.unit = 'day';
                                axis.options.time.stepSize = 1;
                            } else if ((3600 * 24) < duration) {
                                axis.options.time.unit = 'hour';
                                axis.options.time.stepSize = 6;
                            } else if ((3600 * 4) < duration) {
                                axis.options.time.unit = 'hour';
                                axis.options.time.stepSize = 1;
                            } else if ((60 * 60) < duration) {
                                axis.options.time.unit = 'minute';
                                axis.options.time.stepSize = 15
                            } else if ((60 * 15) < duration) {
                                axis.options.time.unit = 'minute';
                                axis.options.time.stepSize = 5
                            } else {
                                axis.options.time.unit = 'minute';
                                axis.options.time.stepSize = 1
                            }
                        }
                    }],
                    yAxes: [{
                        display: true,
                        gridLines: {
                            borderDash: [6, 2]
                        },
                        scaleLabel: {
                            display: true,
                            labelString: graphConfig.dataSets[0].label
                        },
                        ticks: {
                            min: (null != scope.graphConfig.min && '' != scope.graphConfig.min) ? parseFloat(scope.graphConfig.min) : null,
                            max: (null != scope.graphConfig.max && '' != scope.graphConfig.max) ? parseFloat(scope.graphConfig.max) : null
                        }
                    }]
                },
                legend: {
                    display: false
                },
                // pan: {
                //     enabled: true,
                //     mode: 'x',
                //     speed: 10,
                //     threshold: 10
                // },
                // zoom: {
                //     enabled: true,
                //     mode: 'x',
                //     limits: {
                //         max: 10,
                //         min: 0.5
                //     }
                // },
                // plugins: {
                //     zoom: {
                //         // Container for pan options
                //         pan: {
                //             enabled: true,
                //             mode: 'x',
                //             // Function called while the user is panning
                //             onPan: function ({ chart }) { console.log(`I'm panning!!!`); },
                //             // Function called once panning is completed
                //             onPanComplete: function ({ chart }) { console.log(`I was panned!!!`); }
                //         },

                //         // Container for zoom options
                //         zoom: {
                //             enabled: true,
                //             mode: 'x',
                //             // Function called while the user is zooming
                //             onZoom: function ({ chart }) { console.log(`I'm zooming!!!`); },
                //             // Function called once zooming is completed
                //             onZoomComplete: function ({ chart }) { console.log(`I was zoomed!!!`); }
                //         }
                //     }
                // }
            }
        };

        element.height = 500;
        var chart = new Chart(element[0].getContext('2d'), config);
        _this.charts.push(chart);

        graphConfig.chart = chart;

        if (_this.selectedChart === graphConfig) {
            chart.update();
        }



        Chart.pluginService.register({
            afterDraw: function (chart) {
                var ctx = chart.ctx;
                ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);

                var scalesX = chart.scales['x-axis-0'];
                var scalesY = chart.scales['y-axis-0'];
                var minDate = scalesX.min;

                _this.startTime = moment(minDate).format('llll');
                _this.endTime = moment(scalesX.max).format('llll');
                scope.$apply();

                graphConfig.fileConfigurations.forEach(function (fileConfig) {
                    var myRegexp = /(.*\/)?({{date\((\w+)\)}})+.*/;
                    var match = myRegexp.exec(fileConfig.name);
                    if (match && 2 < match.length) {
                        var dateReplacePart = match[3];
                        var datePart = moment(minDate).format(dateReplacePart);

                        // make sure we have an array of previously loaded date strings
                        if (!fileConfig.loadedDates) fileConfig.loadedDates = [];
                        // if we have already loaded a file for this date format then abort
                        if (!fileConfig.loadedDates[datePart]) {
                            console.log(new moment() + ' get ' + fileConfig.name + ' using ' + datePart);
                            _this.getDataFileForDate(fileConfig, minDate);

                            fileConfig.loadedDates[datePart] = true;
                        }
                    }
                });

                // // check to see if the max for this chart is greater or equal to the most recent time
                // var endTime = chart.config.options.scales.xAxes[0].time.max;

                // // go through each dataset and find the max time
                // chart.config.data.datasets.forEach(function (dataset) {
                //     var lastData = dataset.data[dataset.data.length - 1];
                //     _this.realTime &= lastData.x == endTime;
                //     // scope.$apply();
                // });

            }
        });
    };
});
