/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.JanosLib;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.system.Application2;
import com.integpg.janoslib.system.AssemblyInfoBase;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.JDateFormat;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.ApplicationUtils;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;

public abstract class JanosApplication {
    private static final JDateFormat DATE_FORMAT = new JDateFormat().includeMilliseconds(true);
    public static long Start = System.currentTimeMillis();
    private static String _registryRoot = "";
    private static boolean _isBackground = false;
    private AssemblyInfoBase _assemblyInfo;

    public static void exec(JanosApplication janosApplication, AssemblyInfoBase assemblyInfo, String[] args) {
        try {
            boolean isForeground;
            long start = System.currentTimeMillis();
            janosApplication._assemblyInfo = assemblyInfo;
            Object[] objectArray = new Object[1];
            objectArray[0] = assemblyInfo.getName();
            _registryRoot = String.format("AppData/%s/", objectArray);
            AppLog.init(assemblyInfo.getName());
            JanosApplication janosApplication2 = janosApplication;
            JANOS.setRegistryString((String)(_registryRoot + "$Name"), (String)janosApplication2._assemblyInfo.getName());
            JanosApplication janosApplication3 = janosApplication;
            JANOS.setRegistryString((String)(_registryRoot + "$Version"), (String)janosApplication3._assemblyInfo.getVersion());
            JanosApplication janosApplication4 = janosApplication;
            JANOS.setRegistryString((String)(_registryRoot + "$BuildTime"), (String)janosApplication4._assemblyInfo.getBuildTime());
            JANOS.setRegistryString((String)(_registryRoot + "$JanosLibVersion"), (String)JanosLib.getVersion());
            JANOS.setRegistryString((String)(_registryRoot + "$JanosLibBuildTime"), (String)JanosLib.getBuildTime());
            JANOS.setRegistryString((String)(_registryRoot + "$ExecutionTime"), (String)String.valueOf(System.currentTimeMillis()));
            JANOS.setRegistryString((String)(_registryRoot + "$pid"), (String)String.valueOf(JANOS.getProcessID()));
            _isBackground = ApplicationUtils.isBackground();
            janosApplication.logBanner();
            boolean bl = isForeground = !_isBackground;
            if (isForeground) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            JanosApplication janosApplication5 = janosApplication;
            int runningInstances = JANOS.registerProcess((String)janosApplication5._assemblyInfo.getName());
            if (janosApplication.shouldPreventDuplicateInstance() && 1 < runningInstances) {
                JanosApplication janosApplication6 = janosApplication;
                AppLog.error("another instance of " + janosApplication6._assemblyInfo.getName() + " is running");
                System.exit(-1);
            }
            janosApplication.initWatchdog();
            janosApplication.init(args);
            double elapsedSeconds = (double)(System.currentTimeMillis() - Start) / 1000.0;
            AppLog.info(String.format("Application Loaded in %.3f", elapsedSeconds));
            janosApplication.run();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            JanosApplication.fatal(ex);
        }
    }

    protected JanosApplication() {
    }

    public abstract boolean shouldPreventDuplicateInstance();

    public abstract void initWatchdog();

    public abstract void init(String[] var1);

    public abstract void run() throws InterruptedException;

    private void logBanner() {
        Object[] objectArray = new Object[6];
        JanosApplication janosApplication = this;
        objectArray[0] = janosApplication._assemblyInfo.getName();
        JanosApplication janosApplication2 = this;
        objectArray[1] = janosApplication2._assemblyInfo.getVersion();
        JanosApplication janosApplication3 = this;
        objectArray[2] = janosApplication3._assemblyInfo.getBuildTime();
        objectArray[3] = JanosLib.getVersion();
        objectArray[4] = JanosLib.getBuildTime();
        objectArray[5] = JANOS.getVersion();
        String versionString = String.format("%s v%s (built %s) using JanosLib v%s (built %s) running on JANOS %s", objectArray);
        JANOS.syslog((String)versionString);
        AppLog.vital(versionString);
        AppLog.info(String.format("  %s running on S/N: %d, Model: %s", Application2.getAppInstanceName(), UnitConfig.SERIAL_NUMBER, UnitConfig.MODEL));
        this.updateBootLog(versionString);
    }

    private void updateBootLog(String versionString) {
        try {
            String entry = String.format("%s, %s\r\n", DATE_FORMAT.format(System.currentTimeMillis()), versionString);
            File bootlogFile = new File(Application2.getAppName().toLowerCase() + "_boot.log");
            if (16384L < bootlogFile.length() + (long)entry.length()) {
                File bakFile = new File(bootlogFile.getPath() + ".bak");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                bootlogFile.renameTo(bakFile);
            }
            FileUtils.appendAllBytes(bootlogFile.getPath(), entry.getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void sleepForever() {
        try {
            AppLog.info("sleep forever...");
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static void fatal(Object object) {
        JanosApplication.fatal(new RuntimeException(object.toString()));
    }

    public static void fatal(Exception ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        System.err.println(String.format("%s: %s", QuickDateFormat.getDefault().format(), stackTrace));
        System.exit(-1);
    }
}

