/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.xchange;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.ExceptionUtils;
import java.util.Json;

public class JsonBlock {
    private static final String SRC = "src:";
    private static final String DST = ", dst:";
    private static final String CMD = ", cmd:";
    private static final String VAL = ", val:";
    private Json _json;
    private String Source;
    private String Dest;
    private String Command;
    private String Value;
    private String _toString;

    private JsonBlock(Json json) {
        this._json = json;
    }

    public JsonBlock(String source, String dest, String command, String value) {
        this.Source = source;
        this.Dest = dest;
        this.Command = command;
        this.Value = value;
        this._json = new Json();
        this._json.put("source", (Object)source);
        if (dest == null) {
            dest = "-1";
        }
        this._json.put("dest", (Object)dest);
        if (command == null) {
            throw new NullPointerException("Command is null");
        }
        this._json.put("command", (Object)command);
        if (value == null) {
            value = "";
        }
        this._json.put("value", (Object)value);
    }

    public Json getJson() {
        return this._json;
    }

    public String getSource() {
        return this.Source;
    }

    public String getDest() {
        return this.Dest;
    }

    public String getCommand() {
        return this.Command;
    }

    public String getValue() {
        return this.Value;
    }

    public static JsonBlock parseJson(Json json) {
        try {
            JsonBlock jb = new JsonBlock(json);
            jb.Source = (String)json.get("source");
            jb.Dest = (String)json.get("dest");
            jb.Command = (String)json.get("command");
            jb.Value = "";
            if (jb.Value != null) {
                jb.Value = (String)json.get("value");
            }
            return jb;
        }
        catch (NullPointerException ex) {
            AppLog.error(ExceptionUtils.getStackTrace(ex));
            return null;
        }
    }

    public synchronized String toString() {
        if (this._toString == null) {
            StringBuffer _sb = new StringBuffer(64);
            _sb.append(SRC);
            _sb.append(this.Source);
            _sb.append(DST);
            _sb.append(this.Dest);
            _sb.append(CMD);
            _sb.append(this.Command);
            _sb.append(VAL);
            _sb.append(this.Value);
            this._toString = _sb.toString();
        }
        return this._toString;
    }
}

