if (typeof String.prototype.replaceAll !== 'function') {
    String.prototype.replaceAll = function (search, replacement) {
        var target = this;
        return target.replace(new RegExp(search, 'g'), replacement);
    };
}


if (typeof String.prototype.startsWith !== 'function') {
    String.prototype.startsWith = function (searchString, position) {
        position = position || 0;
        return this.indexOf(searchString, position) === position;
    };
}


if (typeof String.prototype.endsWith !== 'function') {
    String.prototype.endsWith = function (suffix) {
        return this.indexOf(suffix, this.length - suffix.length) !== -1;
    };
}


if (typeof String.prototype.trimStrEnd !== 'function') {
    String.prototype.trimStrEnd = function (suffix) {
        var s = this;
        while (s.endsWith(suffix)) {
            s = s.substring(0, s.length - 1);
        }
        return s;
    };
}


if (typeof Number.prototype.leftPad !== 'function') {
    Number.prototype.leftPad = function (digits) {
        var output = this + '';
        while (output.length < digits) {
            output = '0' + output;
        }
        return output;
    };
}


// Speed up calls to hasOwnProperty
var hasOwnProperty = Object.prototype.hasOwnProperty;

function isEmpty(obj) {

    // null and undefined are "empty"
    if (obj == null) return true;

    // Assume if it has a length property with a non-zero value
    // that that property is correct.
    if (obj.length > 0) return false;
    if (obj.length === 0) return true;

    // If it isn't an object at this point
    // it is empty, but it can't be anything *but* empty
    // Is it empty?  Depends on your application.
    if (typeof obj !== "object") return true;

    // Otherwise, does it have any properties of its own?
    // Note that this doesn't handle
    // toString and valueOf enumeration bugs in IE < 9
    for (var key in obj) {
        if (hasOwnProperty.call(obj, key)) return false;
    }

    return true;
}


function getParameterByName(name) {
    var url = window.location.href;
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results)
        return null;
    if (!results[2])
        return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));
}



function getHash() {
    return Math.floor((1 + Math.random()) * 0x10000)
        .toString(16).substring(1);
}



class Callback {
    constructor() {
        this.array = [];
    }


    addCallback(key, callback_fn) {
        const hash = getHash();

        // this.array[key] = callback_fn;
        this.array[hash] = callback_fn;

        return hash;
    }



    alertCallbacks(key, json) {
        // var callback_fn = this.array[key];
        // if (callback_fn) callback_fn(json);

        if (json.Meta && json.Meta.Hash) {
            var callback_fn = this.array[json.Meta.Hash];
            if (callback_fn) callback_fn(json);
        }
    }
}