/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.xchange;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;
import com.integpg.xchange.ClientConnection;
import com.integpg.xchange.ClientConnectionCollection;
import com.integpg.xchange.JsonBlock;
import com.integpg.xchange.MessagePumpListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Json;

public class MessagePumpHandler
implements MessagePumpListener {
    @Override
    public void messageReceived(SystemMsg systemMsg, MessagePump messagePump) {
        SystemMsg responseMsg = new SystemMsg();
        ArrayList<Object> returnedClients = new ArrayList();
        ArrayList<Object> clientsToClear = new ArrayList();
        if (5012 == systemMsg.type) {
            String messagePumpMessage = new String(systemMsg.msg);
            Json json = new Json(messagePumpMessage);
            JsonBlock content = JsonBlock.parseJson(json);
            if (content.getCommand().equalsIgnoreCase("get_clients")) {
                try {
                    returnedClients.clear();
                    returnedClients = ClientConnectionCollection.getClients();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Iterator<Object> e = returnedClients.iterator();
                while (e.hasNext()) {
                    Json[] jsonArray;
                    for (Json jsonCommands : jsonArray = (Json[])e.next()) {
                        responseMsg.type = 5012;
                        responseMsg.msg = jsonCommands.toString().getBytes();
                        messagePump.postMessage(responseMsg);
                    }
                }
            } else if (content.getCommand().equalsIgnoreCase("run_global_macro")) {
                try {
                    ClientConnectionCollection.sendGlobalMacro(content.getValue());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (content.getCommand().equalsIgnoreCase("clear_statuses")) {
                try {
                    clientsToClear.clear();
                    clientsToClear = ClientConnectionCollection.clearClients(content.getValue().toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (Json jsonCommands : clientsToClear) {
                    responseMsg.type = 5012;
                    responseMsg.msg = jsonCommands.toString().getBytes();
                    messagePump.postMessage(responseMsg);
                }
            } else {
                ClientConnection cc = ClientConnectionCollection.getClientById(content.getDest());
                if (cc == null) {
                    AppLog.vital("Could not find a client connection for " + content.getDest());
                } else {
                    boolean handled = false;
                    if (content.getCommand().equalsIgnoreCase("get_macros")) {
                        Enumeration e2 = cc._devicesBySource.elements();
                        while (e2.hasMoreElements()) {
                            ClientConnection.DEVICE_INFO di = (ClientConnection.DEVICE_INFO)e2.nextElement();
                            if (di.MacroNames == null) continue;
                            Json getMacros = new JsonBlock(di.Source, null, "macro_names", di.MacroNames).getJson();
                            responseMsg.type = 5012;
                            responseMsg.msg = getMacros.toString().getBytes();
                            messagePump.postMessage(responseMsg);
                            handled = true;
                        }
                    } else if (content.getCommand().equalsIgnoreCase("get_commands")) {
                        Enumeration e2 = cc._devicesBySource.elements();
                        while (e2.hasMoreElements()) {
                            ClientConnection.DEVICE_INFO di = (ClientConnection.DEVICE_INFO)e2.nextElement();
                            StringBuffer statuses = new StringBuffer();
                            Enumeration e = di.Statuses.keys();
                            while (e.hasMoreElements()) {
                                String key = (String)e.nextElement();
                                if (di.Statuses.get(key) == null) continue;
                                String value = (String)di.Statuses.get(key);
                                if (statuses.length() > 0) {
                                    statuses.append(';');
                                }
                                statuses.append(key);
                                statuses.append('=');
                                statuses.append(value);
                            }
                            if (statuses.length() <= 0) continue;
                            Json getCommands = new JsonBlock(di.Source, null, "status", statuses.toString()).getJson();
                            responseMsg.type = 5012;
                            responseMsg.msg = getCommands.toString().getBytes();
                            messagePump.postMessage(responseMsg);
                            handled = true;
                        }
                    }
                    if (!handled) {
                        cc.sendBinary("json", content.getJson().toString());
                    }
                }
            }
        }
    }
}

