/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tcp;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.tcp.TcpConnectionListener;
import java.io.IOException;
import java.net.Socket;
import java.util.EventObject;

public abstract class TcpConnection {
    public String _filename;
    protected Socket _socket;
    protected TcpConnectionListener _listener;
    private String _ipAddress;

    public TcpConnection(Socket socket) {
        this._socket = socket;
        this._ipAddress = this._socket.getInetAddress().getHostAddress() + ":" + this._socket.getPort();
    }

    public Socket getSocket() {
        return this._socket;
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    protected abstract String getName();

    public void setListener(TcpConnectionListener listener) {
        this._listener = listener;
    }

    public void init() {
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                TcpConnection.this.handleConnection();
            }
        }, this.getIpAddress() + " handle " + this.getName());
        thd.setDaemon(true);
        thd.start();
    }

    protected void handleConnectionLoop() {
        throw new RuntimeException("Not supported yet.");
    }

    private void handleConnection() {
        try {
            this.handleConnectionLoop();
        }
        catch (Exception ex) {
            AppLog.error("Error handling socket: " + ExceptionUtils.getStackTrace(ex));
        }
        this.close();
    }

    protected void close() {
        if (this._socket != null) {
            try {
                this._socket.close();
                this._socket = null;
                if (this._listener != null) {
                    this._listener.connectionClosed(new EventObject(this));
                }
            }
            catch (IOException ex) {
                AppLog.error("Error closing socket: " + ExceptionUtils.getStackTrace(ex));
            }
        }
    }
}

