/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.xchange;

import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;
import com.integpg.xchange.MessagePumpListener;
import java.util.Vector;

public class MessagePumpEngine
implements Runnable {
    private static MessagePumpEngine THIS = new MessagePumpEngine();
    private static final MessagePump MESSAGE_PUMP = new MessagePump();
    private static final Vector LISTENERS = new Vector();
    private static Thread _thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(MessagePumpListener listener) {
        Vector vector = LISTENERS;
        synchronized (vector) {
            LISTENERS.addElement(listener);
        }
    }

    static void start() {
        if (null == _thread) {
            _thread = new Thread(THIS);
            _thread.setName("message-pump-engine");
            _thread.setDaemon(true);
            _thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MESSAGE_PUMP.open();
        while (true) {
            SystemMsg systemMsg = MESSAGE_PUMP.getMessage();
            MESSAGE_PUMP.postMessage(systemMsg);
            Vector vector = LISTENERS;
            synchronized (vector) {
                for (int i = 0; i < LISTENERS.size(); ++i) {
                    MessagePumpListener listener = (MessagePumpListener)LISTENERS.elementAt(i);
                    listener.messageReceived(systemMsg, MESSAGE_PUMP);
                }
            }
        }
    }

    public static void postMessage(SystemMsg msg) {
        MESSAGE_PUMP.postMessage(msg);
    }
}

