/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tcp.server;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.tcp.server.TcpServerEvent;
import com.integpg.tcp.server.TcpServerListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer
implements Runnable {
    private String _name;
    private TcpServerListener _listener = null;
    private ServerSocket svrSocket;
    private Socket socket;
    private int _port;
    private Thread theServer;
    private boolean bServerRun = true;

    public TcpServer(String name, int port) {
        this._name = name;
        this._port = port;
    }

    public void setTcpServerListener(TcpServerListener listener) {
        this._listener = listener;
    }

    public void start() {
        try {
            this.svrSocket = new ServerSocket(this._port);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
        try {
            this.theServer = new Thread((Runnable)this, this._name + " " + this._port);
            this.theServer.setDaemon(true);
            this.theServer.start();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this.svrSocket.close();
        try {
            this.theServer.interrupt();
            this.theServer.join();
        }
        catch (InterruptedException ex) {
            AppLog.error(ExceptionUtils.getStackTrace(ex));
        }
    }

    @Override
    public void run() {
        try {
            AppLog.vital("Listening for clients on port " + this._port + ".");
            while (this.bServerRun) {
                try {
                    this.socket = this.svrSocket.accept();
                    if (this._listener != null) {
                        this._listener.clientConnected(new TcpServerEvent(this, this.socket));
                    }
                }
                catch (IOException ex) {
                    AppLog.error(ExceptionUtils.getStackTrace(ex));
                    this.bServerRun = false;
                }
                catch (Exception ex) {
                    AppLog.error(ExceptionUtils.getStackTrace(ex));
                }
                System.gc();
            }
        }
        catch (Exception ex) {
            AppLog.error(ExceptionUtils.getStackTrace(ex));
            this.bServerRun = false;
        }
        try {
            this.svrSocket.close();
        }
        catch (IOException ex) {
            AppLog.error(ExceptionUtils.getStackTrace(ex));
        }
        this.svrSocket = null;
    }
}

