if (isMobile()) {
    //document.write('<link rel="stylesheet" href="http://code.jquery.com/mobile/1.1.0/jquery.mobile-1.1.0.min.css" />');
    //            document.write('<script src="/jquery/jquery.mobile-1.3.2.min.js"></sc');
    //            document.write('ript>');
} else {
    //            document.write('<script src="/jquery/jquery-ui.min.js"></sc');
    //            document.write('ript>');
}

function isMobile() {
    if (navigator.userAgent.match(/Android/i) || navigator.userAgent.match(/BlackBerry/i) || navigator.userAgent.match(/iPhone|iPad|iPod/i) || navigator.userAgent.match(/IEMobile/i))
        return true;
    return false;
}

// Poll for jQuery to come into existance
var checkReady = function (callback) {
    console.log('jquery is ready ' + window.jQuery);
    if (window.jQuery) {
        callback(jQuery);
    }
    else {
        window.setTimeout(function () { checkReady(callback); }, 100);
    }
};

var mobileReady = function (callback) {
    console.log('mobile is ready ' + window.jQuery);
    if ($.mobile) {
        callback(jQuery);
    }
    else {
        window.setTimeout(function () { mobileReady(callback); }, 100);
    }
};

var waitFlag = true;
var configuration;
var masterJNIOR;


// ******************************************
// Gets the miscellaneous column name from
// html5 local storage
// ******************************************

function getMiscellaneousColumnName() {
    var savedMiscName = localStorage.getItem("misc-column-name");
    if (savedMiscName == null || savedMiscName == "") {
        savedMiscName = "Miscellaneous";
    }
    $('#misc-column-name').val(savedMiscName);
}

function addDevice(source, value) {
    if (waitFlag == false) {
        if ($('#' + source).length == 0) {

            var tr = '<tr height=30 class="clickable" id="' + source + '">' +
                '<td align="center" id="' + source + '_name">' +
                '<div class="device-notconnected" id="' + source + '-connection-status">' +
                '</div>' +
                '<span style="padding-left: 20px">' + value + '</span>' +
                '<div id="macros" class="context-menu" style="display:none;">macros</div>' +
                '</td>';

            var json = JSON.parse(configuration);
            for (x in json.Columns) {
                var columnName = json.Columns[x].name.replaceAll(' ', '_');
                columnName = columnName.trim();
                columnName = columnName.toLowerCase();
                tr += '<td align="center" class="clickable" id="' + source + '_' + columnName + '"';
                if (json.Columns[x].macro != null && json.Columns[x].macro != '') {
                    var macroJson = { "source": null, "dest": source, "command": "run_macro", "value": json.Columns[x].macro };
                    tr += ' style="padding:0px"><button style="width:100%;height:100%" onclick="if (confirm(\'Would you like to execute the ' + json.Columns[x].macro + ' macro?\') == true) { onclick="masterJNIOR.postMessage(\'5012\', \'' + macroJson + '\'); return; }">' + json.Columns[x].macro + '</button>';
                } else {
                    tr += '>';
                }
                tr += '</td>';
            }
            tr += '<td align="center" class="clickable" id="' + source + '_misc"></td>';

            $('#mytable > tbody:last').append(tr);
        }
    }
}

// ******************************************
// Gets the configuration file from the jnior
// using the JnrWebsocket
// ******************************************

async function getConfigurationFile() {

    configuration = await masterJNIOR.readFileAsync('/flash/www/events/configuration.json');
    console.log(configuration);
    //Read configuration file for information on building the EventManager table
    var json = JSON.parse(configuration);
    var jsonColumnConfig;
    try {
        jsonColumnConfig = json.Columns;
    } catch (err) {
        console.log(err);
    }

    // build out the visible columns
    for (x in json.Columns) {
        var columnName = json.Columns[x].name;
        columnName = columnName.trim();
        $("#myTable tr").append("<th id=\"" + columnName.toLowerCase().replaceAll(' ', '_') + "\">" + columnName + "</th>");
    }
    $("#myTable tr").append("<th id=\"misc-header\">" + $('#misc-column-name').val() + "</th>");


    // add the device rows
    for (x in json.Devices) {
        console.log('x ' + x);
        console.log('json ' + json.Devices[x]);
        var source = json.Devices[x].Source;
        var alias = json.Devices[x].Alias;

        var tr = '<tr height=30 class="clickable" id="' + source + '">' +
            '<td align="center" id="' + source + '_name">' +
            '<div class="device-notconnected" id="' + source + '-connection-status">' +
            '</div>' +
            '<span style="padding-left: 20px">' + alias + '</span>' +
            '<div id="macros" class="context-menu" style="display:none;">macros</div>' +
            '</td>';

        for (x in json.Columns) {
            var columnName = json.Columns[x].name.replaceAll(' ', '_');
            columnName = columnName.trim();
            columnName = columnName.toLowerCase();
            tr += '<td align="center" class="clickable" id="' + source + '_' + columnName + '"';
            if (json.Columns[x].macro != null && json.Columns[x].macro != '') {
                var macroJson = { "source": null, "dest": source, "command": "run_macro", "value": json.Columns[x].macro };
                tr += ' style="padding:0px"><button style="width:100%;height:100%" onclick="if (confirm(\'Would you like to execute the ' + json.Columns[x].macro + ' macro?\') == true) { onclick="masterJNIOR.postMessage(\'5012\', \'' + macroJson + '\'); return; }">' + json.Columns[x].macro + '</button>';
            } else {
                tr += '>';
            }
            tr += '</td>';
        }
        tr += '<td align="center" class="clickable" id="' + source + '_misc"></td>';


        $('#mytable > tbody:last').append(tr);
        $('#mytable tr:odd').addClass("altrow");

    }

    // hide columns that the user wants hidden
    try {
        for (x in json.Columns) {
            columnName = json.Columns[x].name;
            columnName = columnName.trim();
            if (jsonColumnConfig != null) {
                if (jsonColumnConfig[columnName.toLowerCase()] == 'false') {
                    var column = $('#' + columnName.toLowerCase().replaceAll(' ', '_'));
                    // get the index for the column
                    var index = column.closest('th').index() + 1;
                    $('#myTable td:nth-child(' + index + '),th:nth-child(' + index + ')').hide();
                    $('#column-selection').append('<input id="cb-' + columnName.toLowerCase().replaceAll(' ', '_') + '" value="' + columnName + '" type="checkbox">' + columnName + '<br />');
                } else {
                    $('#column-selection').append('<input id="cb-' + columnName.toLowerCase().replaceAll(' ', '_') + '" value="' + columnName + '" type="checkbox" checked="true">' + columnName + '<br />');
                }
            } else {
                $('#column-selection').append('<input id="cb-' + columnName.toLowerCase().replaceAll(' ', '_') + '" value="' + columnName + '" type="checkbox" checked="true">' + columnName + '<br />');
            }
        }
    } catch (err) {
        console.log(err);
    }

    waitFlag = false;
    masterJNIOR.postMessage(5012, { "source": null, "dest": null, "command": "get_clients", "value": null });
}

// ******************************************
// Set Intervals
// ******************************************

function setIntervals() {
    // set the interval that will be used to clear the background status update colors
    window.setInterval(function () { myTimer() }, 100);

    // we need to periodically send a 'heartbeat' to the jnior websocket connection
    // window.setInterval('sendHeartbeat();', 30000);
}


// ******************************************
// Document Ready
// ******************************************

var selectedHostname = null;
var nameBySerial = new Array();
var timeoutStack = new Array();
var timeoutPerCell = {};
var connectionCount = 0;
var blockNextMenu = false;
var connectBySource = new Array();
var macrosBySource = new Array();
var selectedSource;

var _connectionStart = new Date().getTime();

// ******************************************
// function that handles when the main JNIOR 
// connects, disconnects, or receives a message
// ******************************************

function setupJnrWebsocket() {
    masterJNIOR.addOnLoggedInListener(async function onLoggedIn() {
        console.log('Took ' + (new Date().getTime() - _connectionStart) + ' to establish the connection');
        console.log("Connected");
        $('#connection-status').attr('class', 'websocket-connected');
        $("#connection_status").html("CONNECTED");


        masterJNIOR.onClosed = (closed) => {
            $('#connection-status').attr('class', 'websocket-notconnected');
            $("#connection_status").html("Disconnected");
            window.setTimeout("openWebSocket()", 1000);
        }

        masterJNIOR.addOnMessageListener(async function listenForProcesses(json) {

            $("#time").html(new Date());

            var source = json['source'];
            var command = json['command'];
            var value = json['value'];
            if (command == 'connect') {

                connectBySource[source] = json;

                if (value.indexOf('|') > 0) {
                    value = value.substring(0, value.indexOf('|'));
                }

                nameBySerial[source] = value;


                // adds a device row
                addDevice(source, value);

                $('#' + source + '_name').bind("click", function (e) {
                    console.log("show macros");
                    if (!blockNextMenu) {
                        showMacroDialog(source);
                        //                        
                    } else {
                        blockNextMenu = false;
                    }
                    return false;
                });

                $("#" + value).click(function () {
                    $('#mytable > tbody  > tr').each(function (j, row) {
                        $(row).removeClass("selected");
                        if (j % 2 == 1) {
                            $(this).addClass("altrow");
                        }
                    });
                    $(this).addClass("selected");
                    $(this).removeClass("altrow");

                    selectedHostname = this.id;
                    $("#log").html("");
                });

                $('#mytable tr:odd').addClass("altrow");

                $('#' + source + '-connection-status').attr('class', 'device-connected');


                // get the number of rows in the table
                var rowCount = $('#myTable tr').length;
                // subtract 1 from the number of rows and that is row manu connections we have
                connectionCount = rowCount - 1;
                $('#connection-count').html(connectionCount);


                // --- disconnected command received ---
            } else if (command == 'disconnected') {

                $('#' + source + '-connection-status').attr('class', 'device-notconnected');
                $('#' + source).find('td').each(function () {
                    if (index > 1) {
                        $(this).html('');
                    }
                });
                // get the number of rows in the table
                var rowCount = $('#myTable tr').length;
                // subtract 1 from the number of rows and that is row manu connections we have
                connectionCount = rowCount - 1;
                $('#connection-count').html(connectionCount);



                // --- status or update command ---
            } else if (command == 'status' || command == 'update') {
                var array = value.split(';');
                //		    	 		console.log(array.length);

                for (var i = 0; i < array.length; i++) {
                    //					console.log(i + ': ' + array[i]);

                    var equalsPos = array[i].indexOf("=");
                    if (equalsPos > 0) {
                        var elementId = array[i].substring(0, equalsPos);
                        elementId = elementId.trim();
                        elementId = elementId.toLowerCase();
                        elementId = elementId.replaceAll(' ', '_');
                        elementId = elementId.toLowerCase()
                        var value = array[i].substring(equalsPos + 1);

                        update(source, elementId, value);
                    }
                }


                // --- macro command received ---
            } else if (command == 'macro_names') {

                macrosBySource[source] = json;


                var sourceRow = $('#' + source);

                var macroNames = value.split(', ');
                var macroNames2 = '<ol>\r\n';
                macroNames2 += '<li><b>' + nameBySerial[source] + '</b></li>\r\n';
                macroNames2 += '</ol><hr>\r\n';
                macroNames2 += '<ol>\r\n';

                macroNames2 += '<li><a href="javascript:void(0);" onclick="showMacroDialog(\'' + source + '\'); return;"><b>Show Control Panel</b></a></li>\r\n';
                macroNames2 += '</ol>\r\n';
                macroNames2 += '<ol>\r\n';
                for (var i = 0; i < macroNames.length; i++) {
                    var macroJson = { "source": null, "dest": source, "command": "run_macro", "value": macroNames[i] };
                    macroNames2 += '<li><a href="javascript:void(0);" onclick="masterJNIOR.postMessage(\'5012\', \'' + macroJson + '\'); return;">' + macroNames[i] + '</a></li>\r\n';



                    var found = false;
                    $('#macro-selection').find(':checkbox').each(function () {
                        if ($(this).attr('value') == macroNames[i]) {
                            found = true;
                            return;
                        }
                    });
                    if (!found) {
                        $('#macro-selection').append('<input id="cb-' + macroNames[i].toLowerCase().replaceAll(' ', '_') + '" value="' + macroNames[i] + '" type="checkbox">' + macroNames[i] + '<br />');
                    }

                }
                macroNames2 += '</ol>';
                sourceRow.find('#macros').html(macroNames2);
            }

        })
    })
}

checkReady(function ($) {
    $(document).ready(function () {

        //Setup the Websocket that will communicate between the exchange application and this.
        masterJNIOR = new JnrWebsocket();
        setupJnrWebsocket();
        masterJNIOR.connect();

        // the document is ready.  hide the loader image
        $('.loader').hide();


        // build the dialogs
        buildDialogs();


        // get the miscellaneous column name from local storage
        getMiscellaneousColumnName();


        // get the configuration file
        (async () => {
            getConfigurationFile();
        })();


        // set intervals for clearing background colors and the websocket heartbeat
        setIntervals();


        // whenever there is a mouse up event we must make sure that the context menu gets hidden
        $(document).bind("mouseup", function () {
            $('.context-menu').hide();
        });

        $(document).on("vmouseup", "div", function () {
            $('.context-menu').hide();
        });

        // bind the click for the config icon
        $('#config-icon').bind("click", function (e) {
            $('#configure-menu').css({ top: ($('#footer').position().top - $('#configure-menu').height() - 10) + "px", left: ($(document).width() - $('#configure-menu').width()) + "px" }).show();
            return false;
        });

    });


    $(window).bind("beforeunload", function () {
        console.log("beforeunload");
        for (win in windows) { //windows.forEach(function(win) {
            console.log("close " + windows[win].toString());
            windows[win].postMessage('{"source":"","command":"close_window","value":""}', "http://10.0.0.70");
        }
    });
});


var windows = new Array();
function openDeviceWindow(deviceId, connect, macros) {
    return win = window.open('/events/macro-grid.html?connect=' + connect + '&macro_names=' + macros, '"' + deviceId + '"', 'width=300,height=500');
}

// ******************************************
// function that handles generating the dialog
// that opens when a JNIOR Connection's row
// is clicked
// ******************************************

function showMacroDialog(source) {
    var json = connectBySource[source];
    var command = json['command'];
    var value = json['value'];

    //make sure it is a connection object
    if (command != 'connect') return;

    if (value.indexOf('|') > 0) {
        value = value.substring(0, value.indexOf('|'));
    }

    selectedSource = source;
    var macroCount = loadMacroNames(macrosBySource[source]);
    var columns = Math.ceil(macroCount / 10);
    var width = Math.min(columns * 250, screen.width);

    $('#dialog-run-macros').dialog('option', 'title', 'Execute Macros for ' + value);
    $('#dialog-run-macros').dialog("option", "width", width);
    $('#dialog-run-macros').dialog('open');
}


// ******************************************
// Updates each column in row with appropriate
// data from EventManager response message
// ******************************************

function update(source, column, value) {
    elementId = source + '_' + column;

    if ($('#' + elementId).length == 0) {
        elementId = source + "_misc";
    }

    $('#' + elementId).html(value);
    $('#' + elementId).addClass("updated");

    var d = new Date();
    var timeout = d.getTime() + 10000;
    timeoutPerCell[elementId] = timeout;
    timeoutStack.unshift({
        elementId: elementId,
        timeout: timeout
    });
}

// endsWith method
function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
}

// ******************************************
// function that finds when a row status has 
// hit a timeout from the updateExecutionStatus
// function and then changes the background
// color to default
// ******************************************

function myTimer(id) {
    while (true) {
        var elapsed = timeoutStack.pop();
        if (elapsed != null) {
            var elementId = elapsed.elementId;
            var timeout = elapsed.timeout;
            var d = new Date();
            if (d.getTime() > elapsed.timeout) {
                var timeout = timeoutPerCell[elementId];
                if (d.getTime() > timeout) {
                    $('#' + elementId).removeClass("updated");
                }
            } else {
                timeoutStack.push(elapsed);
                break;
            }
        } else {
            break;
        }
    }
}

function leadingZeros(number, width) {
    var s = "00000" + number;
    s = s.substring(s.length - width);
    return s;
}

// **************************************
// ReplaceAll by Fagner Brack (MIT Licensed)
// Replaces all occurrences of a substring in a string
// **************************************

String.prototype.replaceAll = function (token, newToken, ignoreCase) {
    var str, i = -1,
        _token;
    if ((str = this.toString()) && typeof token === "string") {
        _token = ignoreCase === true ? token.toLowerCase() : undefined;
        while ((i = (
            _token !== undefined ?
                str.toLowerCase().indexOf(
                    _token,
                    i >= 0 ? i + newToken.length : 0
                ) : str.indexOf(
                    token,
                    i >= 0 ? i + newToken.length : 0
                )
        )) !== -1) {
            str = str.substring(0, i)
                .concat(newToken)
                .concat(str.substring(i + token.length));
        }
    }
    return str;
};


// *************************************
// Hides a column by name
// *************************************

function hideColumn(columnName) {
    // in order to hide the column we must get the index
    var index = columnName.closest('th').index() + 1;
    //            alert(index);
    // now use the index to remove both the table header and the table cell
    $('td:nth-child(' + index + '),th:nth-child(' + index + ')').hide();
}

// ******************************************
// function call from showMacroDialog that 
// grabs all macros from the JNIOR Connection,
// and builds a dialog to execute whichever 
// one is selected
// ******************************************

function loadMacroNames(value) {

    //compare function to sort macros when put into the dialog
    function compare(a, b) {
        if ((/\d+/.test(a)) && (/\d+/.test(b))) {
            return (Number(a.match(/(\d+)/g)[0]) - Number((b.match(/(\d+)/g)[0])));
        } else {
            return a.localeCompare(b);
        }
    }

    var macroConfig = localStorage.getItem('macro-config');
    console.log(macroConfig);
    var jsonMacroConfig;
    try {
        jsonMacroConfig = JSON.parse(macroConfig);
    } catch (err) {
        console.log(err);
    }


    var json = value;
    var source = json['source'];
    var command = json['command'];
    var value = json['value'];

    //make sure it is a macro_names object
    if (command != 'macro_names') return -1;

    var macroNames = value.split(', ');
    //sort the macros using the compare function
    macroNames.sort(compare);
    for (var i = 0; i < macroNames.length; i++) {
        if (jsonMacroConfig != null && jsonMacroConfig[macroNames[i].toLowerCase()] == 'false') {
            macroNames.splice(i, 1);
            i--;
        }
    }


    //Resize window and determine number of macro columns in dialog based on the number of macros in the list.
    var columns = Math.ceil(macroNames.length / 10);
    var width = Math.min(columns * 300, screen.width);
    window.resizeTo(width, window.height);

    var html = '<table border="0" width="100%">';
    console.log("macro count: " + macroNames.length);
    //build out a buton for each macro
    for (var i = 0; i < macroNames.length; i++) {
        //var index = Math.floor(i / columns) + Math.ceil(macroNames.length / columns) * (i % columns);
        //console.log(index);

        if (i % columns == 0) {
            html += '<tr>';
        }

        html += '<td width="' + (100 / columns) + '%">';
        html += '<a href="javascript:void(0);" id="' + i + '" class="button medium gray" style="width:100%;height:40px;"><span style="width:100%;">' + macroNames[i] + '</span></a>';
        html += '</td>';

        if ((i + 1) % columns == 0 || i == macroNames.length - 1) {
            html += '</tr>';
        }
    }
    html += '</table>';

    $('#macro-buttons').html('');
    $('#macro-buttons').append(html);
    console.log($('#macro-buttons').html());


    $('.button').click(function () {
        if (confirm('Are you sure you want to execute the ' + $(this).find('span').html() + ' macro?')) {
            //put message on the message pump to execute a macro
            masterJNIOR.postMessage(5012, { "source": null, "dest": source, "command": "run_macro", "value": $(this).find('span').html() })
        }
    });

    $('.button').mousedown(function () {
        $(this).attr('class', 'button medium white');
    });

    $('.button').mouseleave(function () {
        $(this).attr('class', 'button medium gray');
    });

    $('.button').mouseup(function () {
        $(this).attr('class', 'button medium gray');
    });

    return macroNames.length;
}

// ******************************************
// function that handles generating the dialog
// that opens when the executeGlobalMacro button
// is clicked
// ******************************************

function showGlobalMacroDialog() {

    (async () => {
        //Read of configuration file to know which macros should be availabe for global execution
        var fileRead = await masterJNIOR.readFileAsync('/flash/www/events/configuration.json');
        if (fileRead != null) {
            var parsedJson = JSON.parse(fileRead);
        }

        //Calls the loadMacroNames function to determine column amount and window size
        var macroCount = loadGlobalMacroNames(parsedJson.globalMacro);
        var columns = Math.ceil(macroCount / 10);
        var width = Math.min(columns * 250, screen.width);

        $('#dialog-select-macro-global').dialog('option', 'title', 'Macro to execute on all connected JNIORs');
        $('#dialog-select-macro-global').dialog("option", "width", width);
        $('#dialog-select-macro-global').dialog('open');
    })()
}

// ******************************************
// function call from showGlobalMacroDialog 
// that grabs all macros that have been added
// as a global macro, and builds a dialog to
// execute whichever one is selected
// ******************************************

function loadGlobalMacroNames(macroNames) {
    //Resize window and determine number of macro columns in dialog based on the number of macros in the list.
    var columns = Math.ceil(macroNames.length / 10);
    var width = Math.min(columns * 300, screen.width);
    window.resizeTo(width, window.height);

    var html = '<table border="0" width="100%">';
    console.log("macro count: " + macroNames.length);
    //Sorts macros so buttons are generated in order
    macroNames.sort();
    //Builds out a button for each macro
    for (var i = 0; i < macroNames.length; i++) {
        var index = Math.floor(i / columns) + Math.ceil(macroNames.length / columns) * (i % columns);
        console.log(index);

        if (i % columns == 0) {
            html += '<tr>';
        }

        html += '<td width="' + (100 / columns) + '%">';
        html += '<a href="javascript:void(0);" id="' + index + '" class="button medium gray" style="width:100%;height:40px;"><span style="width:100%;">' + macroNames[index] + '</span></a>';
        html += '</td>';

        if ((i + 1) % columns == 0 || i == macroNames.length - 1) {
            html += '</tr>';
        }
    }
    html += '</table>';
    //Adds buttons to dialog
    $('#macro-selection-global').html('');
    $('#macro-selection-global').append(html);
    console.log($('#macro-selection-global').html());

    //Sends each JNIOR Connection message to execute the same macro on button click
    $('.button').click(function () {
        if (confirm('Are you sure you want to execute the ' + $(this).find('span').html() + ' macro on all connected JNIORs?')) {
            masterJNIOR.postMessage(5012, { "source": null, "dest": null, "command": "run_global_macro", "value": $(this).find('span').html() })
        }
    });

    $('.button').mousedown(function () {
        $(this).attr('class', 'button medium white');
    });

    $('.button').mouseleave(function () {
        $(this).attr('class', 'button medium gray');
    });

    $('.button').mouseup(function () {
        $(this).attr('class', 'button medium gray');
    });

    return macroNames.length;
}

// *************************************
// Ready method for building the dialogs
// *************************************

function buildDialogs() {
    $("#dialog-config").dialog({
        autoOpen: false, height: 275, width: 400, modal: true, show: { effect: "drop", direction: "up", duration: 250 }, hide: { effect: "drop", direction: "up", duration: 250 },
        buttons: {
            OK: function () {
                localStorage.setItem("misc-column-name", $('#misc-column-name').val());
                $('#misc-header').html($('#misc-column-name').val());
                $(this).dialog("close");
            },
            No: function () {
                $(this).dialog("close");
            }
        },
        close: function () { }
    });

    $("#dialog-clear-statuses").dialog({
        autoOpen: false, height: 175, width: 300, modal: true, show: { effect: "drop", direction: "up", duration: 250 }, hide: { effect: "drop", direction: "up", duration: 250 },
        buttons: {
            Yes: function () {
                (async () => {
                    var statusString = "";
                    var fileRead = await masterJNIOR.readFileAsync('/flash/www/events/configuration.json');
                    if (fileRead != null) {
                        var parsedJson = JSON.parse(fileRead);
                    }
                    if (fileRead != null) {
                        jsonColumnConfig = parsedJson.Columns;
                        Object.values(jsonColumnConfig).forEach(value => {
                            if (statusString == "") {
                                statusString = value.name;
                            } else {
                                statusString = statusString + "," + value.name;
                            }
                        })
                    }
                    masterJNIOR.postMessage(5012, { "source": null, "dest": null, "command": "clear_statuses", "value": statusString })
                    $(this).dialog("close");
                })();

            },
            No: function () {
                $(this).dialog("close");
            }
        },
        close: function () { }
    });

    $("#dialog-select-columns").dialog({
        autoOpen: false, height: 475, width: 400, modal: true, show: { effect: "drop", direction: "up", duration: 250 }, hide: { effect: "drop", direction: "up", duration: 250 },
        buttons: {
            OK: function () {
                var columnConfig = '{';
                // go through wach column checkbox and make sure the column visibility matches the selection
                $('#column-selection').find(':checkbox').each(function () {
                    // get the id of the checkbox
                    var id = $(this).attr('value').toLowerCase().replaceAll(' ', '_');
                    // now find the column
                    var column = $('#' + id);
                    // get the index for the column
                    var index = column.closest('th').index() + 1;
                    if ($(this).is(":checked")) {
                        $('#myTable td:nth-child(' + index + '),th:nth-child(' + index + ')').show();
                    } else {
                        $('#myTable td:nth-child(' + index + '),th:nth-child(' + index + ')').hide();
                    }

                    if (columnConfig.length > 1) columnConfig += ',';
                    columnConfig += '"' + id.toLowerCase() + '":"' + $(this).is(":checked") + '"';
                });
                columnConfig += '}';
                console.log("save column config: " + columnConfig);
                localStorage.setItem('column-config', columnConfig);
                $(this).dialog("close");

            },
            Cancel: function () {
                $(this).dialog("close");
            }
        },
        close: function () { }
    });

    $("#dialog-select-macros").dialog({
        autoOpen: false, width: 400, modal: true, show: { effect: "drop", direction: "up", duration: 250 }, hide: { effect: "drop", direction: "up", duration: 250 },
        buttons: {
            OK: function () {
                var macroConfig = '{';
                // go through wach macro checkbox and make sure the column visibility matches the selection
                $('#macro-selection').find(':checkbox').each(function () {
                    // get the id of the checkbox
                    var id = $(this).attr('value').toLowerCase();

                    if (macroConfig.length > 1) macroConfig += ',';
                    macroConfig += '"' + id.toLowerCase() + '":"' + $(this).is(":checked") + '"';
                });
                macroConfig += '}';
                console.log("save macro config: " + macroConfig);
                localStorage.setItem('macro-config', macroConfig);

                $(this).dialog("close");
            },
            Cancel: function () {
                $(this).dialog("close");
            }
        },
        open: function () {
            var macroConfig = localStorage.getItem('macro-config');
            console.log(macroConfig);
            try {
                var jsonMacroConfig = JSON.parse(macroConfig);
            } catch (err) {
                console.log(err);
            }

            $('#macro-selection').find(':checkbox').each(function () {
                // get the id of the checkbox
                var id = $(this).attr('value').toLowerCase();
                if (jsonMacroConfig == null || jsonMacroConfig[id] == 'true') {
                    $(this).prop('checked', true);
                } else {
                    $(this).prop('checked', false);
                }
            });

        },
        close: function () { }
    });

    $("#dialog-add-macro-global").dialog({
        autoOpen: false, height: 275, width: 400, modal: true, show: { effect: "drop", direction: "up", duration: 250 }, hide: { effect: "drop", direction: "up", duration: 250 },
        buttons: {
            OK: function () {
                (async () => {
                    var alreadyExists = false;
                    //get configuration file
                    var fileRead = await masterJNIOR.readFileAsync('/flash/www/events/configuration.json');
                    if (fileRead != null) {
                        //parse configuration file values
                        var parsedJson = JSON.parse(fileRead);
                        if (parsedJson.globalMacro != undefined) {
                            //check if global macro has already been added
                            parsedJson.globalMacro.forEach(function (exisitingMacros) {
                                if (exisitingMacros == $('#macro-add-global').val()) {
                                    alreadyExists = true;
                                    return;
                                };
                            })
                        }
                        if (alreadyExists == false) {
                            if (parsedJson.globalMacro != undefined) {
                            } else {
                                parsedJson["globalMacro"] = [];
                            }
                            var varcheck = $('#macro-add-global').val();
                            //add global macro to configuration file
                            parsedJson.globalMacro.push($('#macro-add-global').val().trim());
                            await masterJNIOR.writeFileAsync('/flash/www/events/configuration.json', JSON.stringify(parsedJson, null, 2));
                        }
                    }
                    $(this).dialog("close");
                })();
            },
            No: function () {
                $(this).dialog("close");
            }
        },
        close: function () { }
    });

    $("#dialog-remove-macro-global").dialog({
        autoOpen: false, height: 275, width: 400, modal: true, show: { effect: "drop", direction: "up", duration: 250 }, hide: { effect: "drop", direction: "up", duration: 250 },
        open: function () {
            (async () => {
                //get configuration file
                var fileRead = await masterJNIOR.readFileAsync('/flash/www/events/configuration.json');
                if (fileRead != null) {
                    //parse configuration file values
                    var parsedJson = JSON.parse(fileRead);
                    parsedJson.globalMacro.forEach(function (exisitingMacros) {
                        //builds out checkboxes for dialog that will be used to remove global macros
                        $("#dialog-remove-macro-global").append('<div id="' + exisitingMacros + ' name"><input type="checkbox" id="' + exisitingMacros + '" name="' + exisitingMacros + '" > ' + exisitingMacros + '</div></br>');
                    })

                }
            })();
        },
        buttons: {
            OK: function () {
                (async () => {
                    //get configuration file
                    var fileRead = await masterJNIOR.readFileAsync('/flash/www/events/configuration.json');
                    if (fileRead != null) {
                        //parse configuration file values
                        var parsedJson = JSON.parse(fileRead);
                        if (parsedJson.globalMacro != undefined) {
                            $('#dialog-remove-macro-global').find(':checkbox').each(function () {
                                //for each macro checked remove it from the global macros in the configuration file
                                if ($(this).is(":checked")) {
                                    parsedJson.globalMacro.splice(parsedJson.globalMacro.indexOf($(this).attr('id')), 1);
                                }

                            })
                        }
                        await masterJNIOR.writeFileAsync('/flash/www/events/configuration.json', JSON.stringify(parsedJson));
                    }
                    $(this).dialog("close");
                })();
            },
            No: function () {
                $(this).dialog("close");
            }
        },
        close: function () { $("#dialog-remove-macro-global").html("<p>Select a macro to remove from the global macro buttons.</p>"); }
    });

    $("#dialog-select-macro-global").dialog({
        autoOpen: false, height: 600, width: 400, modal: true, show: { effect: "drop", direction: "up", duration: 250 }, hide: { effect: "drop", direction: "up", duration: 250 },
        open: function () {
            showGlobalMacroDialog(masterJNIOR);
        },
        buttons: {
            OK: function () {

                // for (const [key, value] of Object.entries(peerDictionary)) {
                //     peerDictionary[key].ws.postMessage(2000, { Message: 'macro.execute', MacroName: $('#macro-selection-global').val() });
                $(this).dialog("close");
                // }
            }
        },
        close: function () { }
    });

    $("#dialog-run-macros").dialog({
        autoOpen: false, height: 600, width: 300, modal: true,
        buttons: {
            Close: function () {
                $(this).dialog("close");
            }
        },
        close: function () { }
    });

}