/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.xchange;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import com.integpg.tcp.MessageReceivedEvent;
import com.integpg.tcp.TcpConnection;
import com.integpg.xchange.AssemblyInfo;
import com.integpg.xchange.JsonBlock;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Json;

public class ClientConnection
extends TcpConnection {
    static final Logger LOG = Logger.getLogger(AssemblyInfo.getName() + "_device.log");
    private static int READ_TIMEOUT = 30000;
    private static Object staticLock = new Object();
    private byte[] _outgoingBytes = new byte[0];
    byte[] _sBytes = new byte[4096];
    int _sBytePos = 0;
    private InputStream _dis;
    private byte[] inbuf = new byte[512];
    private int inbufPos;
    private int inbufLen;
    private String _terminationString = "\r\n";
    private int _terminationOffset = 0;
    private long _asciiElapsed;
    private long _processAsciiElapsed;
    public Hashtable _devicesBySource = new Hashtable();
    private int count = 0;

    public ClientConnection(Socket socket) {
        super(socket);
        try {
            this._dis = new DataInputStream(socket.getInputStream());
        }
        catch (IOException ex) {
            LOG.error(ex);
        }
    }

    @Override
    protected String getName() {
        return "client";
    }

    public synchronized String getStatusCache(String source) {
        DEVICE_INFO di = (DEVICE_INFO)this._devicesBySource.get(source);
        return di.getStatusCache();
    }

    public void processAvailableData() {
        block27: {
            try {
                DEVICE_INFO di;
                int readByte = this.getByte();
                if (readByte == 1) {
                    BINARY_PACKET bp = this.processBinary();
                    if (this._listener != null) {
                        this._listener.messageReceived(new MessageReceivedEvent(this, new String(bp.Value)));
                    }
                    break block27;
                }
                long start = JANOS.uptimeMillis();
                String _ascii = this.processAscii(readByte);
                this._asciiElapsed = JANOS.uptimeMillis() - start;
                if (_ascii == null || _ascii.equals("")) {
                    return;
                }
                Json jobj = new Json(_ascii);
                JsonBlock jsonblock = JsonBlock.parseJson(jobj);
                String source = jsonblock.getSource();
                if (!this._devicesBySource.containsKey(source)) {
                    di = new DEVICE_INFO();
                    di.Source = source;
                    di.IpAddress = this._socket.getInetAddress().getHostAddress();
                    this._devicesBySource.put(source, di);
                } else {
                    di = (DEVICE_INFO)this._devicesBySource.get(source);
                }
                if (jsonblock.getCommand().equalsIgnoreCase("connect")) {
                    try {
                        di.Alias = jsonblock.getValue();
                    }
                    catch (Exception ex) {
                        AppLog.error("error during command connect: " + _ascii);
                    }
                } else if (jsonblock.getCommand().equalsIgnoreCase("macro_names")) {
                    try {
                        di.MacroNames = jsonblock.getValue();
                    }
                    catch (Exception ex) {
                        AppLog.error("error during command macro_names: " + _ascii);
                    }
                } else if (jsonblock.getCommand().equalsIgnoreCase("status")) {
                    try {
                        String value = jsonblock.getValue();
                        String[] parts = StringUtils.split(value, ";");
                        for (int i = 0; i < parts.length; ++i) {
                            String part = parts[i];
                            int equalsPos = part.indexOf("=");
                            if (equalsPos > 0) {
                                String key = part.substring(0, equalsPos).trim();
                                part = part.substring(equalsPos + 1).trim();
                                di.Statuses.put(key, part);
                            }
                            di._statusCache = null;
                        }
                    }
                    catch (Exception ex) {
                        AppLog.error("error during command update: " + _ascii);
                    }
                } else if (jsonblock.getCommand().equalsIgnoreCase("update")) {
                    try {
                        String value = jsonblock.getValue();
                        int equalsPos = value.indexOf("=");
                        if (equalsPos > 0) {
                            String key = value.substring(0, equalsPos).trim();
                            value = value.substring(equalsPos + 1).trim();
                            di.Statuses.put(key, value);
                        }
                        di._statusCache = null;
                    }
                    catch (Exception ex) {
                        AppLog.error("error during command update: " + _ascii);
                    }
                }
                if (this._listener != null) {
                    this._listener.messageReceived(new MessageReceivedEvent(this, jsonblock));
                }
            }
            catch (EOFException ex) {
                LOG.error("Close Client Connection: Remote Client Closed the Connection.");
                this.close();
            }
            catch (Exception ex) {
                LOG.error("Close Client Connection: " + ExceptionUtils.getStackTrace(ex));
                this.close();
            }
        }
    }

    private int getByte() throws IOException {
        if (this.inbufPos == this.inbufLen) {
            if (this._dis == null) {
                throw new IOException("InputStream is null");
            }
            long start = JANOS.uptimeMillis();
            try {
                this.inbufLen = this._dis.read(this.inbuf, 0, this.inbuf.length);
            }
            catch (SocketTimeoutException ex) {
                if (JANOS.uptimeMillis() - start < 30000L) {
                    AppLog.error("Incorrect Socket Timeout");
                }
                throw ex;
            }
            finally {
                this.inbufPos = 0;
            }
            if (this.inbufLen == -1) {
                throw new EOFException("Client Disconnected");
            }
        }
        if (this.inbufPos != this.inbufLen) {
            return this.inbuf[this.inbufPos++] & 0xFF;
        }
        throw new IOException("no bytes available");
    }

    @Override
    protected void handleConnectionLoop() {
        Thread.currentThread().setName(this.getIpAddress() + " handle client");
        if (this._listener != null) {
            this._listener.connectionEstablished(new EventObject(this));
        }
        try {
            this._socket.setSoTimeout(READ_TIMEOUT);
            while (this._socket != null) {
                if (this._dis == null) {
                    throw new Exception("InputStream is null");
                }
                this.processAvailableData();
            }
        }
        catch (EOFException ex) {
            LOG.error("Close Client Connection: Remote Client Closed the Connection.");
        }
        catch (Exception ex) {
            LOG.error("Close Client Connection: " + ExceptionUtils.getStackTrace(ex));
        }
    }

    private String processAscii(int readByte) throws Exception {
        String s;
        String terminationString = this._terminationString;
        this._sBytePos = 0;
        char terminationChar = terminationString.charAt(this._terminationOffset);
        while (true) {
            if (this._sBytes.length == this._sBytePos) {
                byte[] sBytes = new byte[this._sBytes.length + 64];
                System.arraycopy(this._sBytes, 0, sBytes, 0, this.count);
                this._sBytes = sBytes;
            }
            this._sBytes[this._sBytePos++] = (byte)readByte;
            if (readByte == terminationChar) {
                ++this._terminationOffset;
                if (this._terminationOffset == terminationString.length()) break;
                terminationChar = terminationString.charAt(this._terminationOffset);
            } else {
                this._terminationOffset = 0;
            }
            if (this.inbufPos == this.inbufLen) {
                readByte = this.getByte();
                continue;
            }
            readByte = this.inbuf[this.inbufPos++] & 0xFF;
        }
        this._terminationOffset = 0;
        try {
            s = new String(this._sBytes, 0, this._sBytePos - terminationString.length());
        }
        catch (Exception ex) {
            System.out.println(Thread.currentThread().getName() + " " + new String(this._sBytes, 0, this._sBytePos) + " " + this._sBytePos + " " + this._terminationString.length());
            throw ex;
        }
        return s;
    }

    private BINARY_PACKET processBinary() throws IOException {
        int lengthOfPacket = this.getByte() * 256;
        lengthOfPacket += this.getByte();
        int len = this.getByte() * 256;
        byte[] bytes = new byte[len += this.getByte()];
        this.loadByteArray(bytes, len);
        String name = new String(bytes);
        len = this.getByte() * 256;
        bytes = new byte[len += this.getByte()];
        this.loadByteArray(bytes, len);
        BINARY_PACKET bp = new BINARY_PACKET();
        bp.Name = name;
        bp.Value = bytes;
        return bp;
    }

    private void loadByteArray(byte[] array, int length) throws IOException {
        int pos = 0;
        while (length > 0) {
            array[pos++] = (byte)this.getByte();
            --length;
        }
    }

    public void clearCache(DEVICE_INFO di) {
        di._statusCache = null;
        di.Statuses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBinary(String command, String commandString) {
        ClientConnection clientConnection = this;
        synchronized (clientConnection) {
            try {
                int length = 5 + command.length() + commandString.length();
                if (length > this._outgoingBytes.length) {
                    this._outgoingBytes = new byte[length];
                    this._outgoingBytes[0] = 1;
                }
                int pos = 1;
                this._outgoingBytes[pos++] = (byte)((length -= 3) / 256);
                this._outgoingBytes[pos++] = (byte)(length % 256);
                this._outgoingBytes[pos++] = (byte)command.length();
                ArrayUtils.arraycopy((Object)command.getBytes(), (int)0, (Object)this._outgoingBytes, (int)pos, (int)command.length());
                pos += command.length();
                this._outgoingBytes[pos++] = (byte)commandString.length();
                ArrayUtils.arraycopy((Object)commandString.getBytes(), (int)0, (Object)this._outgoingBytes, (int)pos, (int)commandString.length());
                this._socket.getOutputStream().write(this._outgoingBytes, 0, pos += commandString.length());
                this._socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                LOG.error(ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    class BINARY_PACKET {
        public String Name;
        public byte[] Value;

        BINARY_PACKET() {
        }
    }

    class DEVICE_INFO {
        public String Source;
        public String Alias;
        public String IpAddress;
        public String MacroNames;
        public Hashtable Statuses = new Hashtable();
        private StringBuffer _statusCacheBuffer = new StringBuffer();
        private String _statusCache = null;

        DEVICE_INFO() {
        }

        public synchronized String getStatusCache() {
            if (this._statusCache == null) {
                Enumeration e2 = this.Statuses.keys();
                this._statusCacheBuffer.setLength(0);
                while (e2.hasMoreElements()) {
                    String key = (String)e2.nextElement();
                    if (this.Statuses.get(key) == null) continue;
                    String value = (String)this.Statuses.get(key);
                    if (this._statusCacheBuffer.length() > 0) {
                        this._statusCacheBuffer.append(';');
                    }
                    this._statusCacheBuffer.append(key);
                    this._statusCacheBuffer.append('=');
                    this._statusCacheBuffer.append(value);
                }
                this._statusCache = this._statusCacheBuffer.toString();
            }
            return this._statusCache;
        }
    }
}

