/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.xchange;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import com.integpg.system.SystemMsg;
import com.integpg.tcp.MessageReceivedEvent;
import com.integpg.tcp.TcpConnectionListener;
import com.integpg.tcp.server.TcpServer;
import com.integpg.tcp.server.TcpServerEvent;
import com.integpg.tcp.server.TcpServerListener;
import com.integpg.xchange.ClientConnection;
import com.integpg.xchange.JsonBlock;
import com.integpg.xchange.MessagePumpEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Json;
import java.util.Vector;

public class ClientConnectionCollection
implements TcpServerListener,
TcpConnectionListener {
    private static final ClientConnectionCollection _instance;
    private static final Hashtable _clientConnectionsByDeviceId;
    private static final Vector _clientConnections;
    private static int _connectionCount;
    static long LastConnectionTime;

    public static void acceptClientConnections(int port) {
        AppLog.vital("Starting Client Connection Server");
        TcpServer server = new TcpServer("Client Server port", port);
        server.setTcpServerListener(_instance);
        server.start();
    }

    public static ClientConnection getClientById(String id) {
        return (ClientConnection)_clientConnectionsByDeviceId.get(id);
    }

    public static ArrayList<Json[]> getClients() throws IOException {
        ArrayList<Json[]> jsonArrayList = new ArrayList<Json[]>();
        Enumeration e = _clientConnections.elements();
        while (e.hasMoreElements()) {
            ClientConnection cc = (ClientConnection)e.nextElement();
            Enumeration e2 = cc._devicesBySource.elements();
            while (e2.hasMoreElements()) {
                try {
                    Json statusCommand;
                    Json macroCommand;
                    ClientConnection.DEVICE_INFO di = (ClientConnection.DEVICE_INFO)e2.nextElement();
                    Json connectCommand = new JsonBlock(di.Source, null, "connect", di.Alias != null ? di.Alias : "").getJson();
                    Json[] jsonCommands = new Json[]{connectCommand, macroCommand = new JsonBlock(di.Source, null, "macro_names", di.MacroNames).getJson(), statusCommand = new JsonBlock(di.Source, null, "status", di.getStatusCache()).getJson()};
                    jsonArrayList.add(jsonCommands);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return jsonArrayList;
    }

    public static void sendGlobalMacro(String macroName) throws IOException {
        Enumeration e = _clientConnections.elements();
        while (e.hasMoreElements()) {
            ClientConnection cc = (ClientConnection)e.nextElement();
            Json macroExecute = new JsonBlock(null, null, "run_macro", macroName).getJson();
            cc.sendBinary("json", macroExecute.toString());
        }
    }

    public static ArrayList<Json> clearClients(String columnNamesString) throws IOException {
        ArrayList<Json> jsonArrayList = new ArrayList<Json>();
        Enumeration e = _clientConnections.elements();
        while (e.hasMoreElements()) {
            ClientConnection cc = (ClientConnection)e.nextElement();
            Enumeration e2 = cc._devicesBySource.elements();
            while (e2.hasMoreElements()) {
                try {
                    ClientConnection.DEVICE_INFO di = (ClientConnection.DEVICE_INFO)e2.nextElement();
                    StringBuilder statuses = new StringBuilder();
                    Enumeration e3 = di.Statuses.keys();
                    while (e3.hasMoreElements()) {
                        String key = (String)e3.nextElement();
                        if (di.Statuses.get(key) == null) continue;
                        String value = "";
                        if (statuses.length() > 0) {
                            statuses.append(';');
                        }
                        statuses.append(key);
                        statuses.append('=');
                        statuses.append(value);
                    }
                    if (statuses.length() > 0) {
                        Json clearCommand = new JsonBlock(di.Source, null, "status", statuses.toString()).getJson();
                        jsonArrayList.add(clearCommand);
                    }
                    System.out.println("columnNamesString: " + columnNamesString);
                    String[] columnNames = StringUtils.split(columnNamesString, ",");
                    StringBuilder statuses2 = new StringBuilder();
                    for (String columnName : columnNames) {
                        System.out.println("columnName: " + columnName);
                        String value = "";
                        if (statuses2.length() > 0) {
                            statuses2.append(';');
                        }
                        statuses2.append(columnName);
                        statuses2.append('=');
                        statuses2.append(value);
                    }
                    if (statuses2.length() > 0) {
                        Json clearCommand = new JsonBlock(di.Source, null, "status", statuses2.toString()).getJson();
                        jsonArrayList.add(clearCommand);
                    }
                    di.Statuses.clear();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return jsonArrayList;
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        ClientConnection connection = new ClientConnection(evt.getSocket());
        connection.setListener(this);
        connection.init();
        _clientConnections.addElement(connection);
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        try {
            ClientConnection connection = (ClientConnection)evt.getSource();
            ClientConnection.LOG.vital(connection.getIpAddress() + " Client Connected #" + ++_connectionCount);
            LastConnectionTime = JANOS.uptimeMillis();
        }
        catch (Exception ex) {
            AppLog.error(ExceptionUtils.getStackTrace(ex));
        }
    }

    @Override
    public void connectionClosed(EventObject evt) {
        try {
            ClientConnection connection = (ClientConnection)evt.getSource();
            ClientConnection.LOG.vital(connection.getIpAddress() + " Client Disconnected");
            _clientConnections.removeElement(connection);
            Enumeration e = connection._devicesBySource.elements();
            while (e.hasMoreElements()) {
                ClientConnection.DEVICE_INFO di = (ClientConnection.DEVICE_INFO)e.nextElement();
                JsonBlock jsonblock = new JsonBlock(di.Source, null, "disconnected", "");
                SystemMsg systemMsg = new SystemMsg();
                systemMsg.msg = jsonblock.toString().getBytes();
                systemMsg.type = 5012;
                MessagePumpEngine.postMessage(systemMsg);
                _clientConnectionsByDeviceId.remove(di.Source);
            }
        }
        catch (Exception ex) {
            AppLog.error(ExceptionUtils.getStackTrace(ex));
        }
    }

    @Override
    public void messageReceived(MessageReceivedEvent evt) {
        this.handleClientMessage(evt);
    }

    private void handleClientMessage(MessageReceivedEvent evt) {
        try {
            ClientConnection connection = (ClientConnection)evt.getSource();
            JsonBlock jsonblock = (JsonBlock)evt.getMessage();
            ClientConnection.LOG.info(jsonblock.toString());
            if (!_clientConnectionsByDeviceId.containsKey(jsonblock.getSource())) {
                _clientConnectionsByDeviceId.put(jsonblock.getSource(), connection);
            }
            Json json = jsonblock.getJson();
            SystemMsg systemMsg = new SystemMsg();
            systemMsg.msg = json.toString().getBytes();
            systemMsg.type = 5012;
            MessagePumpEngine.postMessage(systemMsg);
        }
        catch (Exception ex) {
            AppLog.error(ExceptionUtils.getStackTrace(ex));
            ex.printStackTrace();
        }
    }

    static {
        _clientConnectionsByDeviceId = new Hashtable();
        _clientConnections = new Vector();
        _connectionCount = 0;
        LastConnectionTime = JANOS.uptimeMillis();
        _instance = new ClientConnectionCollection();
    }
}

