package com.integ.common.net;

import java.util.EventObject;

public class BytesReceivedEvent extends EventObject {

    private final byte[] _bytes;
    private final int _offset;
    private final int _length;



    public BytesReceivedEvent(Object source, byte[] bytes, int offset, int length) {
        super(source);
        _bytes = bytes;
        _offset = offset;
        _length = length;
    }



    public byte[] getBytes() {
        return _bytes;
    }



    public int getOffset() {
        return _offset;
    }



    public int getLength() {
        return _length;
    }
}

