package com.integpg.janoslib.datastructures;

public class LinkedList {

    private LinkedListNode _head = null;



    public LinkedList() {

    }



    public int getLength() {
        int length = 0;
        LinkedListNode node = _head;
        while (null != node) {
            node = node.getNextNode();
            length++;
        }
        return length;
    }



    public LinkedListNode getFirstNode() {
        return _head;
    }



    public void addNode(LinkedListNode newNode) {
//        System.out.println("Add Node: " + newNode);

        if (null == _head) {
            _head = newNode;
        } else {
            LinkedListNode node = _head;
            LinkedListNode prevNode = null;
//            System.out.println(node);
            while (null != node) {
                if (node.shouldInsertNode(newNode)) {
                    if (null == prevNode) {
                        newNode.setNextNode(_head);
                        _head = newNode;
                    } else {
                        newNode.setNextNode(prevNode.getNextNode());
                        prevNode.setNextNode(newNode);
                    }
//                    System.out.println("Inserted " + newNode + " before " + node);
                    return;
                }
                if (null == node.getNextNode()) break;
                prevNode = node;
                node = node.getNextNode();
//                System.out.println(node);
            }
            node.setNextNode(newNode);
        }
    }



    public void removeNode(LinkedListNode oldNode) {
//        System.out.println("Remove Node: " + newNode);

        if (null != _head) {
            LinkedListNode node = _head;
            LinkedListNode prevNode = null;
//            System.out.println(node);
            while (null != node) {
                if (node == oldNode) {
                    if (null != prevNode) {
                        prevNode.setNextNode(oldNode.getNextNode());
                    } else {
                        _head = oldNode.getNextNode();
                    }
//                    System.out.println("Removed " + oldNode);
                    return;
                }
                if (null == node.getNextNode()) break;
                prevNode = node;
                node = node.getNextNode();
//                System.out.println(node);
            }
        }
    }



    public void printList() {
        System.out.println(getLength() + " nodes");
        System.out.println(_head.toString());
    }



    public LinkedListNode pop() {
        LinkedListNode head = _head;
        _head = _head.getNextNode();
        return head;
    }
}

