package com.integpg.janoslib.datastructures;

import java.util.ArrayList;
import java.util.EmptyStackException;

public class Queue<T> extends ArrayList<T> {

    /**
     * Creates an empty Stack.
     */
    public Queue() {
    }



    /**
     * Pushes an item onto the top of this stack. This has exactly the same effect as:
     * <blockquote><pre>
     * addElement(item)</pre></blockquote>
     *
     * @param item the item to be pushed onto this stack.
     * @return the <code>item</code> argument.
     * @see java.util.Vector#addElement
     */
    public T enqueue(T item) {
        super.add(item);

        return item;
    }



    public T elementAt(int index) {
        return (T) super.get(index);
    }



    /**
     * Removes the object at the top of this stack and returns that object as the value of this function.
     *
     * @return The object at the top of this stack (the last item of the <tt>Vector</tt> object).
     * @exception EmptyStackException if this stack is empty.
     */
    public synchronized T dequeue() {
        return super.remove(0);
    }



    /**
     * Looks at the object at the top of this stack without removing it from the stack.
     *
     * @return the object at the top of this stack (the last item of the <tt>Vector</tt> object).
     * @exception EmptyStackException if this stack is empty.
     */
    public synchronized T peek() {
        int len = size();

        if (len == 0)
            throw new EmptyStackException();
        return (T) elementAt(0);
    }



    /**
     * Tests if this stack is empty.
     *
     * @return  <code>true</code> if and only if this stack contains no items; <code>false</code> otherwise.
     */
    public boolean isEmpty() {
        return size() == 0;
    }



    /**
     * Returns the 1-based position where an object is on this stack. If the object <tt>o</tt> occurs as an item in this
     * stack, this method returns the distance from the top of the stack of the occurrence nearest the top of the stack;
     * the topmost item on the stack is considered to be at distance <tt>1</tt>. The <tt>equals</tt>
     * method is used to compare <tt>o</tt> to the items in this stack.
     *
     * @param o the desired object.
     * @return the 1-based position from the top of the stack where the object is located; the return value
     * <code>-1</code> indicates that the object is not on the stack.
     */
    public synchronized int search(T o) {
        int i = lastIndexOf(o);

        if (i >= 0) {
            return size() - i;
        }
        return -1;
    }

}

