package com.integ.common.logging;

import com.integ.common.utils.StringUtils;

/**
 * Hold the options for a log file. These options are the file location, maximum size, and the log
 * type. The log type
 * specifying the logic used when the log reaches its maximum size.
 *
 * @since 5.0
 */
public class LogOptions {

    private final String _filePath;
    private int _maxFileSize = 64 * 1024; // default



    public LogOptions(Class classObject) {
        String className = classObject.getName();
        className = StringUtils.replaceAll(className, "/", ".");
        String filepath = className + ".log";
        if (!filepath.startsWith("/")) {
            filepath = "/" + filepath;
        }
        this._filePath = filepath;
    }



    /**
     * creates LogOptions with the specified filePath. The default maximum file size of 32K will be
     * used as well as the
     * default log type of a RollingFile.
     *
     * @param filepath the path to the file in the file system
     * @since 5.0
     */
    public LogOptions(String filepath) {
        if (!filepath.startsWith("/")) {
            filepath = "/" + filepath;
        }
        this._filePath = filepath;
    }



    /**
     * gets the defined file path
     *
     * @return a String containing the file path in the file system
     * @since 5.0
     */
    public String getFilePath() {
        return _filePath.toLowerCase();
    }



    /**
     * gets the defined maximum file size
     *
     * @return an integer that represents the maximum size of the file
     * @since 5.0
     */
    public int getMaxFileSize() {
        return _maxFileSize;
    }



    /**
     * sets the defined maximum file size in KB
     *
     * @param maxFileSize defines a new maximum size for the file in KB
     * @since 5.1
     */
    public LogOptions setMaxFileSizeInKb(int maxFileSize) {
        this._maxFileSize = maxFileSize * 1024;
        return this;
    }

}

