package com.integ.common.net.protocols.modbus;

import com.integ.common.net.protocols.modbus.protocols.ModbusProtocol;
import java.util.Hashtable;

public class ModbusCollection {

    private static final Hashtable MODBUS_COLLECTION = new Hashtable();



    public static void add(String name, ModbusProtocol modbusProtocol) {
        synchronized (MODBUS_COLLECTION) {
            MODBUS_COLLECTION.put(name, modbusProtocol);
        }
    }



    public static ModbusProtocol get(String name) {
        synchronized (MODBUS_COLLECTION) {
            if (MODBUS_COLLECTION.containsKey(name)) {
                Object o = MODBUS_COLLECTION.get(name);
                if (null != o) return (ModbusProtocol) o;
                else return null;
            } else return null;
        }
    }



    public static boolean contains(String name) {
        synchronized (MODBUS_COLLECTION) {
            return MODBUS_COLLECTION.containsKey(name);
        }
    }
}

