package com.integ.common.net;

import com.integ.common.logging.AppLog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UdpServer implements Runnable, IClient {

    private final int _port;
    private Thread _thd = null;
    private UdpConnectionListener _listener;
    private String _socketInfo;



    public UdpServer(int port) {
        _port = port;
    }



    public void setListener(UdpConnectionListener listener) {
        _listener = listener;
    }



    public void start() {
        if (null == _thd) {
            _thd = new Thread(this);
            _thd.setName("UDP Server " + _port);
            _thd.setDaemon(true);
            _thd.start();
        }
    }



    public void run() {
        try {
            AppLog.vital("Listening for clients on udp port " + _port + ".");

            DatagramSocket serverSocket = new DatagramSocket(_port);
            while (true) {
                byte[] data = new byte[128];
                DatagramPacket packet = new DatagramPacket(data, data.length);
                serverSocket.receive(packet);

                _socketInfo = packet.getAddress().getHostAddress() + ":" + packet.getPort() + " (udp)";
                data = packet.getData();
                String s = new String(data, 0, packet.getLength());
                if (null != _listener) _listener.processMessage(this, packet, s);
            }
        } catch (SocketException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }



    public void send(String s) {
        // do nothing
    }



    public String getSocketInfo() {
        return _socketInfo;
    }
}

