package com.integ.common.net;

import com.integ.common.logging.AppLog;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer
        implements Runnable {

    private final String _name;
    private TcpServerListener _listener = null;
    private ServerSocket svrSocket;
    private Socket socket;
    private final int _port;
    private Thread _thread;
    private boolean bServerRun = true;



    /**
     * Creates a new instance of TcpServer
     */
    public TcpServer(String name, int port) {
        _name = name;
        _port = port;
    }



    public void setTcpServerListener(TcpServerListener listener) {
        _listener = listener;
    }



    public void start() {
        /**
         * try to listen on the port. if we cant, that means another instance is. gracefully exit
         */
        try {
            AppLog.info("Start server for " + _name + " clients on port " + _port + ".");
            svrSocket = new ServerSocket(_port);
        } catch (IOException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }

        try {
            // Start the server in background
            _thread = new Thread(this);
            _thread.setName(this.getClass().getName() + ":" + _port);
            _thread.setDaemon(true);
            _thread.start();
        } catch (RuntimeException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
    }



    public void stop() throws IOException {
        bServerRun = false;
        svrSocket.close();

        try {
            _thread.interrupt();
            _thread.join();
        } catch (InterruptedException ex) {
            AppLog.error("Error stopping server socket: " + ex.getMessage());
        }
    }



    public void run() {
        try {
            AppLog.info("Listening for " + _name + " clients on port " + _port + ".");

            // Listen for a Client connections
            while (bServerRun) {
                /* server runs forever */

                try {
                    socket = svrSocket.accept();

                    if (_listener != null) {
                        _listener.clientConnected(new TcpServerEvent(this, socket));
                    }

                } catch (IOException ex) {
                    AppLog.error("Error accepting server socket connection: " + ex.getMessage());
                    bServerRun = false;
                } catch (Exception ex) {
                    AppLog.error("Error accepting server socket connection: " + ex.getMessage());
                }
            }
            /* server runs forever */

        } /* An Exception is normally thrown here if we are stopping the service
         *  so the event is logged ONLY if the server is still supposed to be running.
         */ catch (Exception ex) {
            AppLog.error("Error accepting server socket connection: " + ex.getMessage());
            bServerRun = false;
        }

        try {
            svrSocket.close();
        } catch (IOException ex) {
            AppLog.error("Error closing server socket: " + ex.getMessage());
        }
        svrSocket = null;
    }
}

