//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/


package com.integpg.comm;

import java.util.EventObject;

/**
 *
 * @author Bruce Cloutier
 */
public class SerialPortEvent extends EventObject
{

    /**
     * Clear To Send
     */
    public static final int CTS = 0x01;

    /**
     * Parity Error
     */
    public static final int PE = 0x02;

    /**
     * Overrun Error
     */
    public static final int OE = 0x04;

    /**
     * Framing Error
     */
    public static final int FE = 0x08;

    /**
     * Output buffer is empty
     */
    public static final int OUTPUT_BUFFER_EMPTY = 0x10;

    /**
     * Data is available from the port
     */
    public static final int DATA_AVAILABLE = 0x20;

    /**
     * Break Interrupt
     */
    public static final int BI = 0x40;

    private int eventType;
	private boolean oldValue;
	private boolean newValue;

    /**
     * Constructs a SerialPortEvent with the specified serial port, event type, old and new values.
     * 
     * @param serialport the port
     * @param eventtype an event type
     * @param oldval old value
     * @param newval new value
     */
    public SerialPortEvent(SerialPort serialport, int eventtype, boolean oldval, boolean newval)
	{}

    /**
     * Get the event type.
     * 
     * @return type
     */
    public int getEventType()
	{}

    /**
     * Gets the new value of the state change that caused the SerialPortEvent to be propagated.
     * 
     * @return the value
     */
    public boolean getNewValue()
	{}

    /**
     * Gets the old value of the state change that caused the SerialPortEvent to be propagated.
     * 
     * @return the value
     */
    public boolean getOldValue()
	{}
}
