//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 9-Jun-2012
 * -------------------------------------------------------------------------*/

/*
 * Provides low-level native interface to the underlying JANOS standard C
 * library I/O.
 */

package com.integpg.comm;

import java.io.*;

/**
 *
 * @author Bruce Cloutier
 */
public class SerialOutputStream
    extends OutputStream
{

    /**
     * NULL
     */
    public static final int NULL = 0;

    /**
     * STDOUT
     */
    public static final int STDOUT = 2;

    /**
     * STDERR
     */
    public static final int STDERR = 3;

    /**
     * COMOUT
     */
    public static final int COMOUT = 5;

    /**
     * AUXOUT
     */
    public static final int AUXOUT = 7;

    // Handle for the output stream

    /**
     * outputHandle
     */
        public int outputHandle = STDOUT;

    private SerialOutputStream ()
    {}

    /**
     *
     * @param handle ?
     */
    public SerialOutputStream (int handle)
    {}

    /**
     * open
     */
    public void open ()
    {}

    /**
     * close
     */
    @Override
    public void close ()
    {}

    // Transmit character to the output stream
    static native void putchar(int ch, int handle);

    // Transmit buffer of data to the output stream
    static native void putstr(byte[] data, int offset, int len, int handle);

    /**
     *
     * @param ch ?
     */
    @Override
    public synchronized void write (int ch)
    {}

    /**
     *
     * @param data ?
     * @param ofs ?
     * @param len ?
     */
    @Override
    public synchronized void write (byte[] data, int ofs, int len)
    {}

    /**
     *
     */
    @Override
    public void flush()
    {}

}
