
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;

// Referenced classes of package java.net:
//			Inet6Address, InetAddress, PlainSocketImpl, Socket, 
//			SocketException, SocketImpl, SocketImplFactory

/**
 *
 * @author Bruce
 */

public class ServerSocket
{

	private static SocketImplFactory factory;
	private SocketImpl impl;

    /**
     * Creates an unbound server socket.
     *
     * @exception IOException IO error when opening the socket.
     */
	private ServerSocket()
	{}

    /**
     * Creates a server socket, bound to the specified port. A port of
     * <code>0</code> creates a socket on any free port.
     * <p>
     * The maximum queue length for incoming connection indications (a
     * request to connect) is set to <code>50</code>. If a connection
     * indication arrives when the queue is full, the connection is refused.
     * <p>
     * If the application has specified a server socket factory, that
     * factory's <code>createSocketImpl</code> method is called to create
     * the actual socket implementation. Otherwise a "plain" socket is created.
     * <p>
     * If there is a security manager,
     * its <code>checkListen</code> method is called
     * with the <code>port</code> argument
     * as its argument to ensure the operation is allowed.
     * This could result in a SecurityException.
     *
     *
     * @param locport  the port number, or <code>0</code> to use any
     *                   free port.
     *
     * @exception  IOException  if an I/O error occurs when opening the socket.
     * @exception  SecurityException
     * if a security manager exists and its <code>checkListen</code>
     * method doesn't allow the operation.
     */
	public ServerSocket(int locport)
		throws IOException
	{}

    /**
     * Creates a server socket and binds it to the specified local port
     * number, with the specified backlog.
     * A port number of <code>0</code> creates a socket on any
     * free port.
     * <p>
     * The maximum queue length for incoming connection indications (a
     * request to connect) is set to the <code>backlog</code> parameter. If
     * a connection indication arrives when the queue is full, the
     * connection is refused.
     * <p>
     * If the application has specified a server socket factory, that
     * factory's <code>createSocketImpl</code> method is called to create
     * the actual socket implementation. Otherwise a "plain" socket is created.
     * <p>
     * If there is a security manager,
     * its <code>checkListen</code> method is called
     * with the <code>port</code> argument
     * as its argument to ensure the operation is allowed.
     * This could result in a SecurityException.
     *
     * <P>The <code>backlog</code> argument must be a positive
     * value greater than 0. If the value passed if equal or less
     * than 0, then the default value will be assumed.
     * <P>
     *
     * @param      locport     the specified port, or <code>0</code> to use
     *                      any free port.
     * @param nqueue ?
     *
     * @exception  IOException  if an I/O error occurs when opening the socket.
     * @exception  SecurityException
     * if a security manager exists and its <code>checkListen</code>
     * method doesn't allow the operation.
     *
     * @see        java.net.SocketImpl
     * @see        java.net.SocketImplFactory#createSocketImpl()
     * @see        java.net.ServerSocket#setSocketFactory(java.net.SocketImplFactory)
     * @see        SecurityManager#checkListen
     */
	public ServerSocket(int locport, int nqueue)
		throws IOException
	{}

    /**
     * Create a server with the specified port, listen backlog, and
     * local IP address to bind to.  The <i>bindAddr</i> argument
     * can be used on a multi-homed host for a ServerSocket that
     * will only accept connect requests to one of its addresses.
     * If <i>bindAddr</i> is null, it will default accepting
     * connections on any/all local addresses.
     * The port must be between 0 and 65535, inclusive.
     *
     * <P>If there is a security manager, this method
     * calls its <code>checkListen</code> method
     * with the <code>port</code> argument
     * as its argument to ensure the operation is allowed.
     * This could result in a SecurityException.
     *
     * <P>The <code>backlog</code> argument must be a positive
     * value greater than 0. If the value passed if equal or less
     * than 0, then the default value will be assumed.
     * <P>
     * @param locport the local TCP port
     * @param nqueue ?
     * @param locaddr ?
     *
     * @throws  SecurityException if a security manager exists and
     * its <code>checkListen</code> method doesn't allow the operation.
     *
     * @throws  IOException if an I/O error occurs when opening the socket.
     */
	public ServerSocket(int locport, int nqueue, InetAddress locaddr)
		throws IOException
	{}

    /**
     *
     * @return ?
     * @throws IOException ?
     */
    public Socket accept()
		throws IOException
	{}

    /**
     *
     * @throws IOException ?
     */
    public void close()
		throws IOException
	{}

    /**
     *
     * @return ?
     */
    public InetAddress getInetAddress()
	{}

    /**
     *
     * @return ?
     */
    public int getLocalPort()
	{}

    /**
     *
     * @return ?
     * @throws IOException ?
     */
    public synchronized int getSoTimeout()
		throws IOException
	{}

    /**
     *
     * @param socket ?
     * @throws IOException ?
     */
    protected final void implAccept(Socket socket)
		throws IOException
	{}

    /**
     *
     * @param i ?
     * @throws SocketException ?
     */
    public synchronized void setSoTimeout(int i)
		throws SocketException
	{}

    /**
     *
     * @param negotiate ?
     * @throws SocketException ?
     */
    public synchronized void setSecure(boolean negotiate)
		throws SocketException
	{}

    /**
     *
     * @param socketimplfactory ?
     * @throws IOException ?
     */
    public static void setSocketFactory(SocketImplFactory socketimplfactory)
		throws IOException
	{}

	public String toString()
	{}
}
