//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 15-May-2015
 * -------------------------------------------------------------------------*/

package com.integpg.system;

/**
 *
 * @author Bruce Cloutier
 */
public final class Timebase {

    /**
     * Class cannot be instantiated.
     */
    private Timebase() throws Exception {}
    
    /**
     * Gets the number of milliseconds since system boot. This can be used for general timing.
     *
     * @return number of milliseconds since boot
     */
    public static native long uptimeMillis();

    /**
     * Gets the number of microseconds since system boot. This can be used for accurate timing.
     *
     * @return number of microseconds since boot
     */
    public static native long uptimeMicros();

    /**
     * Returns the current time zone.
     *
     * @return The time zone abbreviation (without Daylight Savings aliasing)
     */
    public static native String getTimeZone();

    /**
     * Returns the current time in milliseconds since the January 1st 1970 at 00:00:00 GMT epoch. This
     *  is the Unix timestamp expressed in milliseconds (not seconds).
     * 
     * @return current time expressed in milliseconds
     */
    public static native long currentTimeMillis();

    /**
     * Returns the current time in milliseconds since the January 1st 1970 at 00:00:00 GMT epoch. This
     *  is the Unix timestamp expressed in milliseconds (not seconds). This explicitly reads the
     *  hardware Real-Time Clock (RTC). Use {@code currentTimeMillis()}. It is much faster.
     * 
     * @return current time expressed in milliseconds
     * @since JANOS v1.5.1
     */
    public static native long currentTimeRTC();

    /**
     * Sets the current time in milliseconds since the January 1st 1970 at 00:00:00 GMT epoch. This
     *  is the Unix timestamp expressed in milliseconds (not seconds). This method sets the current
     *  time and updates the RTC.Note that if NTP is operational this setting may be overwritten.
     * 
     * @since JANOS v1.5.1
     */
    public static native void setCurrentTime(long millis);

    /**
     * Returns the current time offset between the uptime and the RTC in milliseconds.
     * 
     * @return current time offset in milliseconds
     */
    public static native long currentTimeOffset();

    /**
     * Returns the TRUE if the provided time is DST for the given time zone.
     * 
     * @param time specific time to check
     * @param tz time zone
     * @return TRUE if DST
     */
    public static boolean isDST(long time, String tz)
    {}
    private static native boolean tz_isDST(long time, byte tzname[]);

    /**
     * Returns the String representation of the abbreviation for DST in the time zone or
     *  null if there is no abbreviation.
     * 
     * @param tz time zone
     * @return DST abbreviation or null
     */
    public static String getDSTTimeZone(String tz)
    {}
    private static native String tz_DSTnam(byte tzname[]);

    /**
     * Converts the supplied NTP timestamp to the time in milliseconds since the
     * January 1st 1970 at 00:00:00 GMT epoch. This is the Unix timestamp expressed
     * in milliseconds (not seconds).
     * 
     * @return time expressed in milliseconds
     * @since JANOS v1.5.1
     */
    public static native long convertFromNTP(long timestamp);

    /**
     * Converts the supplied time in milliseconds since the January 1st 1970 at 00:00:00 GMT 
     * epoch to the NTP timestamp format.
     * 
     * @return time expressed in the NTP timestamp format
     * @since JANOS v1.5.1
     */
    public static native long convertToNTP(long timemillis);

}
