package com.integ.common.logging;

import java.io.FileNotFoundException;
import java.io.PrintStream;

public class RollingFileLog extends FileLog {

    /**
     * since the FileLog class cannot be instantiated we use this public method to get an instance
     * of a FileLog. This
     * also cashes the instances that it creates so that another call to this method for the same
     * filename will return
     * the same instance.
     *
     * @param logOptions the options for the log
     * @return a Logger instance
     * @since 5.0
     */
    public static Logger getLog(LogOptions logOptions) {
        try {
            synchronized (FileLogService.LOGS_CACHE) {
                String filename = logOptions.getFilePath().toLowerCase();
                if (!FileLogService.LOGS_CACHE.containsKey(filename)) {
                    System.out.println("rolling log file: " + filename + " with max size of " + logOptions.getMaxFileSize());
                    FileLog fileLog = new RollingFileLog(logOptions);
                    FileLogService.LOGS_CACHE.put(filename, fileLog);
                }
                return (Logger) FileLogService.LOGS_CACHE.get(filename);
            }
        } catch (Exception ex) {
            ex.printStackTrace(System.out);
            return SystemOutLog.getLogger();
        }
    }



    /**
     * a private constructor used by the getLog static method
     *
     * @param logOptions
     * @throws FileNotFoundException
     * @since 5.0
     */
    private RollingFileLog(LogOptions logOptions) throws FileNotFoundException {
        _logOptions = logOptions;

        LogOutputStream logOutputStream = new RollingLogOutputStream(logOptions);

        super.setPrintStream(new PrintStream(
                new BufferedLineOutputStream(logOutputStream, 1024)));

//        _isBackground = Application.isBackground();
    }



    @Override
    public void finalize() {
        super.finalize();
    }
}

