package com.integ.common.utils;

import com.integpg.system.JANOS;
import java.util.Json;

public class JsonUtils {

    public static String getString(Json json, String jsonPath, String defaultValue) {
        long start = JANOS.uptimeMillis();
        int lastPeriod = jsonPath.lastIndexOf(".");
        json = getJson(json, jsonPath.substring(0, lastPeriod));
        if (json == null) return defaultValue;
        String key = jsonPath.substring(lastPeriod + 1);
        String s = ObjectUtils.getString(json.get(key), defaultValue);
        long elapsed = JANOS.uptimeMillis() - start;
        System.out.println("  : " + elapsed);
        return s;
    }



    public static boolean getBoolean(Object o, boolean defaultValue) {
        boolean b = defaultValue;
        if (o != null) {
            if (o instanceof Boolean) b = ((Boolean) o).booleanValue();
            else b = (Boolean.valueOf((String) o)).booleanValue();
        }
        return b;
    }



    public static int getInt(Object o, int defaultValue) {
        int i = defaultValue;
        if (o != null) {
            String s = (String) o;
            if (s.length() > 0) i = Integer.parseInt((String) o);
        }
        return i;
    }



    public static long getLong(Object o, long defaultValue) {
        long l = defaultValue;
        if (o != null) {
            String s = (String) o;
            if (s.length() > 0) l = Long.valueOf((String) o);
        }
        return l;
    }



    public static double getDouble(Object o, double defaultValue) {
        double d = defaultValue;
        if (o != null) d = Double.valueOf((String) o).doubleValue();
        return d;
    }



    public static Json getJson(Json json, String jsonPath) {
        json = (Json) get(json, jsonPath);
        return json;
    }



    public static Object get(Json json, String jsonPath) {
        String[] jsonPathParts = StringUtils.split(jsonPath, ".");
        for (int i = 0; i < jsonPathParts.length - 1; i++) {
            System.out.println("json get: " + jsonPathParts[i]);
            if (json.get(jsonPathParts[i]) != null) json = (Json) json.get(jsonPathParts[i]);
            else return null;
        }
        System.out.println("json get: " + jsonPathParts[jsonPathParts.length - 1]);
        return json.get(jsonPathParts[jsonPathParts.length - 1]);
    }
}
