package com.integ.janoslib.protocols.modbus.functions;

import java.io.DataOutputStream;
import java.io.IOException;

public class ReadHoldingRegistersRequest extends ModbusFunctionRequest {

    private final int _startingAddress;
    private final int _quantityOfRegisters;



    public ReadHoldingRegistersRequest(int startingAddress, int quantityOfRegisters) {
        super(3, new ReadHoldingRegistersResponse());
        _startingAddress = startingAddress;
        _quantityOfRegisters = quantityOfRegisters;
    }



    @Override
    public int getRequestLength() {
        return 5;
    }



    @Override
    public void write(DataOutputStream outputStream) throws IOException {
        super.write(outputStream);
        outputStream.writeShort(_startingAddress);
        outputStream.writeShort(_quantityOfRegisters);
    }

}

