package com.integ.common.net.protocols.modbus.functions;

import com.integpg.system.ArrayUtils;



public class ReadHoldingRegisters extends ModbusPdu {

    private final int _startingAddress;
    private final int _quantityOfRegisters;



    public ReadHoldingRegisters(int startingAddress, int quantityOfRegisters) {
        super(3);

        _startingAddress = startingAddress;
        _quantityOfRegisters = quantityOfRegisters;

        byte[] data = new byte[4];
        ArrayUtils.setShort(data, 0, (short) startingAddress);
        ArrayUtils.setShort(data, 2, (short) quantityOfRegisters);
        super.setData(data);
    }



    public int getStartingAddress() {
        return _startingAddress;
    }



    public int getQuantityOfRegisters() {
        return _quantityOfRegisters;
    }
}
