package com.integ.common.net.protocols.modbus.connections;

import com.integ.common.net.TCPConnectionListenerNotifier;
import com.integ.common.net.TcpConnectionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.EventObject;

public class TcpModbusConnection extends ModbusConnection {

    private final String _ipAddress;
    private final int _port;
    private Socket _socket = null;
    private InputStream _inputStream;
    private OutputStream _outputStream;
    private String _connectionInfomationString = "Not Connected";

    private final TCPConnectionListenerNotifier _connectionListenerNotifier = new TCPConnectionListenerNotifier();



    public TcpModbusConnection(String ipAddress, int port) {
        _ipAddress = ipAddress;
        _port = port;
    }



    public void addConnectionListener(TcpConnectionListener listener) {
        _connectionListenerNotifier.addConnectionListener(listener);
    }



    @Override
    public InputStream getInputStream() throws IOException {
        return _inputStream;
    }



    @Override
    public OutputStream getOutputStream() throws IOException {
        return _outputStream;
    }



    @Override
    public void beginWrite() throws IOException {
        ensureConnection();
    }



    @Override
    public void endWrite(int bytesWritten) {
        if (bytesWritten < 0) closeConnection();
    }



    public String getClientInfo() {
        return _connectionInfomationString;
    }



    private void ensureConnection() throws IOException {
//        System.out.println("socket: " + _socket);
        if (_socket == null) {
            _connectionInfomationString = String.format("%s:%d", _ipAddress, _port);

            //
            // wrap the connection attemp call in a try catch so that any bug in user code 
            // cant affect this connection attempt
            try {
                _connectionListenerNotifier.notifyConnectionAttempt(new EventObject(this));
            } catch (Exception ex) {
            }

            try {
                System.out.println("new modbus connection to " + _ipAddress + ":" + _port);

                _socket = new Socket(_ipAddress, _port);
                _connectionInfomationString = String.format("%s:%d using local %d", _ipAddress, _port, _socket.getLocalPort());
                _inputStream = _socket.getInputStream();
                _outputStream = _socket.getOutputStream();
                _socket.setSoTimeout(5000);

                //
                // wrap the connection established call in a try catch so that any bug in 
                // user code cant affect this connection attempt
                try {
                    _connectionListenerNotifier.notifyConnectionEstablished(new EventObject(this));
                } catch (Exception ex) {
                }
            } catch (IOException ex) {
                closeConnection();
                throw new IOException(String.format("Unable to connect to %s:%d", _ipAddress, _port));
            }
        }
    }



    @Override
    public void closeConnection() {
        if (_socket != null) {
            try {
                System.out.println("closing connection");
                _socket.close();
                _inputStream = null;
                _outputStream = null;

                //
                // wrap the connection closed call in a try catch so that any bug in 
                // user code cant affect this connection attempt
                try {
                    _connectionListenerNotifier.notifyConnectionClosed(new EventObject(this));
                } catch (Exception ex) {
                }
            } catch (IOException ex) {
            } finally {
                _socket = null;
                _connectionInfomationString = "Not Connected";
            }
        }
    }



    @Override
    public boolean isConnected() {
        return (null != _socket);
    }

}

