package com.integ.common.logging;

import java.text.QuickDateFormat;

public class FileLog extends Logger {

    protected LogOptions _logOptions;

    private final QuickDateFormat _quickDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    private final String _firstEntry = String.format("%s, %s",
            _quickDateFormat.format(System.currentTimeMillis()),
            "--------------------------------------------------");

    private long _nextFlushTime = Long.MAX_VALUE;
    private boolean _firstWrite = true;
//    private boolean _isBackground;



//
//
//    /**
//     * since the FileLog class cannot be instantiated we use this public method to get an instance
//     * of a FileLog. This
//     * also cashes the instances that it creates so that another call to this method for the same
//     * filename will return
//     * the same instance.
//     *
//     * @param logOptions the options for the log
//     * @return a Logger instance
//     * @since 5.0
//     */
//    public static Logger getLog(LogOptions logOptions) {
//        try {
//            synchronized (FileLogService.LOGS_CACHE) {
//                String filename = logOptions.getFilePath().toLowerCase();
//                if (!FileLogService.LOGS_CACHE.containsKey(filename)) {
//                    System.out.println("log file: " + filename + " with max size of " + logOptions.getMaxFileSize());
//                    FileLog fileLog = new FileLog(logOptions);
//                    FileLogService.LOGS_CACHE.put(filename, fileLog);
//                }
//                return (Logger) FileLogService.LOGS_CACHE.get(filename);
//            }
//        } catch (FileNotFoundException ex) {
//            ex.printStackTrace(System.out);
//            return new SystemOutLog();
//        }
//    }
//    /**
//     * a private constructor used by the getLog static method
//     *
//     * @param logOptions
//     * @throws FileNotFoundException
//     * @since 5.0
//     */
//    private FileLog(LogOptions logOptions) throws FileNotFoundException {
//        _logOptions = logOptions;
//
//        LogOutputStream logOutputStream = null;
//        if (LogTypes.Rolling == _logOptions.getLogType()) logOutputStream = new RollingLogOutputStream(logOptions);
//        else if (LogTypes.SingleBak == _logOptions.getLogType()) logOutputStream = new BakLogOutputStream(logOptions);
//
//        if (null != logOutputStream) {
//            super.setPrintStream(new PrintStream(
//                    new BufferedLineOutputStream(logOutputStream, 1024)));
//        }
//
////        _isBackground = Application.isBackground();
//    }
    @Override
    protected void println(String s) {
        synchronized (this) {
            if (_firstWrite) {
                // make an entry for "--------------------------------------------------" to indicate 
                // that this was the start of the application
                super.println(_firstEntry);
                _firstWrite = false;
            }

//            if (!_isBackground) {
            System.out.println(s);
//            }

            super.print(String.format("%s, %s\r\n", _quickDateFormat.format(System.currentTimeMillis()), s));
            // update when the flush should commit a non-full buffer to the file
            _nextFlushTime = System.currentTimeMillis() + 5000;

            // if we write to this file but its already been finalized then we need to force the flush
            if (_finalized) {
                // to make sure the flush gets forced we must set the next flush time to now
                _nextFlushTime = System.currentTimeMillis();
                flush();
            }
        }
    }



    /**
     * Flushes the current PrintStream instance. This is called by the FileLogService to make sure
     * uncommitted content
     * is committed in a reasonable amount of time.
     *
     * @since 5.0
     */
    @Override
    public void flush() {
        synchronized (this) {
            if (System.currentTimeMillis() >= _nextFlushTime) {
//                System.out.println(String.format("%s flushed", _logOptions.getFilePath()));
                _printStream.flush();
                _nextFlushTime = Long.MAX_VALUE;
            }
        }
    }



    /**
     * Called by the garbage collector when the object goes out of scope. Here we will make sure any
     * uncommitted file
     * content gets committed by calling flush.
     *
     * @since 5.0
     */
    @Override
    public void finalize() {
        if (null != _logOptions) {
            System.out.println(String.format("%s finalize", _logOptions.getFilePath()));
            // to make sure the flush gets forced we must set the next flush time to now
            _nextFlushTime = System.currentTimeMillis();
            flush();

            _finalized = true;
        }
    }

}

