/** INTEG Process Group, Inc.
 *
 * JANOS Operating Software - Java Class Libraries
 * Copyright (c) 2012-2016  All Rights Reserved.
 *
 */

package java.lang;

/**
 *
 * @author Bruce
 */
public final class StringBuilder extends AbstractStringBuilder {

    /**
     * Constructs a string builder with initial capacity of 32.
     */
    public StringBuilder() {}

    /**
     * Constructs a string builder with initial capacity specified.
     *
     * @param cap initial capacity
     * @throws NegativeArraySizeException if argument is less than 0
     */
    public StringBuilder(int cap) {}

    /**
     * Constructs a string builder initialized to the contents of the
     * specified string.
     *
     * @param str initial contents
     */
    public StringBuilder(String str) {}
    
    public StringBuilder append(Object obj) {}

    public StringBuilder append(String str) {}

    public StringBuilder append(StringBuffer sb) {}

    public StringBuilder append(char[] str) {}

    public StringBuilder append(char[] str, int ofs, int len) {}

    public StringBuilder append(boolean b) {}

    public StringBuilder append(char c) {}

    public StringBuilder append(int i) {}

    public StringBuilder append(long lng) {}

    public StringBuilder append(float f) {}

    public StringBuilder append(double d) {}

    public StringBuilder delete(int start, int end) {}

    public StringBuilder deleteCharAt(int idx) {}

    public StringBuilder replace(int start, int end, String str) {}

    /**
     * Inserts a subset of a character array into the string at the specified offset.
     * 
     * @param idx point within the string to insert a portion of the character array
     * @param arr character array
     * @param ofs offset into the character array specifying the portion to insert
     * @param len length of substring from the array to be inserted
     * @return this object
     */
    public StringBuilder insert(int idx, char[] arr, int ofs, int len)
    {}

    /**
     * Inserts a string representation of the object into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the object
     * @param obj the object to insert
     * @return this object
     */
    public StringBuilder insert(int ofs, Object obj) {}

    /**
     * Inserts into the string at the specified offset.
     * 
     * @param ofs point within the string to insert
     * @param str string to be inserted
     * @return this object
     */
    public StringBuilder insert(int ofs, String str) {}

    /**
     * Inserts the character array into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the character array
     * @param arr character array
     * @return this object
     */
    public StringBuilder insert(int ofs, char[] arr) {}

    /**
     * Inserts "true" or "false" into the string at the specified offset based upon a boolean value.
     * 
     * @param ofs point within the string to insert the boolean
     * @param bool true inserts "true", false inserts "false"
     * @return this object
     */
    public StringBuilder insert(int ofs, boolean bool) {}

    /**
     * Inserts the a character into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the character
     * @param ch character to insert
     * @return this object
     */
    public StringBuilder insert(int ofs, char ch) {}

    /**
     * Inserts the string representation of a int value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val int value to represent
     * @return this object
     */
    public StringBuilder insert(int ofs, int val) {}

    /**
     * Inserts the string representation of a long value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val long value to represent
     * @return this object
     */
    public StringBuilder insert(int ofs, long val) {}

    /**
     * Inserts the string representation of a float value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val float value to represent
     * @return this object
     */
    public StringBuilder insert(int ofs, float val) {}

    /**
     * Inserts the string representation of a double value into the string at the specified offset.
     * 
     * @param ofs point within the string to insert the number
     * @param val double value to represent
     * @return this object
     */
    public StringBuilder insert(int ofs, double val) {}

    /**
     * Returns the index within this string of the first occurrence of the specified substring.
     * 
     * @param str substring to match
     * @return index of the first occurrence of the substring
     */
    public int indexOf(String str) {}

    /**
     * Returns the index within this string of the first occurrence of the specified substring. The search
     * can begin at a specified offset.
     * 
     * @param str substring to match
     * @param from index offset to begin search
     * @return index of the first occurrence of the substring
     */
    public int indexOf(String str, int from) {}

    /**
     * Returns the index within this string of the last occurrence of the specified substring.
     * 
     * @param str substring to match
     * @return index of the last occurrence of the substring
     */
    public int lastIndexOf(String str) {}

    /**
     * Returns the index within this string of the last occurrence of the specified substring. The search
     * can begin at a specified offset.
     * 
     * @param str substring to match
     * @param from index offset to begin search
     * @return index of the last occurrence of the substring
     */
    public int lastIndexOf(String str, int from) {}

    public String toString() {}
}
