//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 28-Mar-2016
 * -------------------------------------------------------------------------*/

package com.integpg.system;

/**
 * Provides programmatic access to IO logging. Allows for historical processing of IO signal
 * activity.
 * 
 * @author Bruce Cloutier
 */
public class Iolog {
    
    /**
     * EDGE_FALLING A flag indicating that the falling edge (transition from ON to OFF) is of interest.
     */
    public static final int EDGE_FALLING = 0;

    /**
     * EDGE_RISING A flag indicating that the rising edge (transition from OFF to ON) is of interest.
     */
    public static final int EDGE_RISING = 1;

    /**
     * EDGE_ANY A flag indicating that any change of state is of interest.
     */
    public static final int EDGE_ANY = 2;
    
    private int m_handle = 0;
    
    /** 
     * Creates an instance of the IOLOG. This is initialized with a snapshot
     * of both the Input and Output IO log. The Iolog object will represent the 
     * IO history as of instantiation.
     */
    public Iolog() {}
    
    /** 
     * Updates the log snapshot. The Iolog object will now reflect the IO
     * history as of this moment.
     * 
     */
    public void refresh() {}
    
    /** 
     * Updates the log snapshot. The Iolog object will reflect only the events
     * occurring since the provided timestamp. If the parameter is 0 then only
     * new events that have occurred since the previous snapshot are captured.
     * 
     * @param timestamp include events since this time (incremental if 0)
     */
    public void refresh(long timestamp) {}
    
    /** 
     * Obtains the timestamp associated with the snapshot. This is the precise
     * time of the snapshot in real time. 
     * 
     * @return long value representing the time of the snapshot
     */
    public long gettime() {}

    /** 
     * Obtain an array of all Input events.
     * 
     * @return array of IoEvent objects in order from the most recent
     */
    public IoEvent[] getInputEvents() {}
    
    /** 
     * Obtain an array of recent Input events.
     * 
     * @param limit maximum number of events to return
     * @return array of IoEvent objects in order from the most recent
     */
    public IoEvent[] getInputEvents(int limit) {}

    /** 
     * Obtain an array of all Output events.
     * 
     * @return array of IoEvent objects in order from the most recent
     */
    public IoEvent[] getOutputEvents() {}
    
    /** 
     * Obtain an array of recent Output events.
     * 
     * @param limit maximum number of events to return
     * @return array of IoEvent objects in order from the most recent
     */
    public IoEvent[] getOutputEvents(int limit) {}
    
    /** 
     * Returns array of Input transition timestamps for the specified channel.
     * 
     * @param chan selected channel (0-N)
     * @return array of long timestamps in order from the most recent
     */
    public long[] getInputTransitions(int chan) {}
    
    /** 
     * Returns array of Output transition timestamps for the specified channel.
     * 
     * @param chan selected channel (0-N)
     * @param edge filters by edge specified (EDGE_ALL, EDGE_RISING or EDGE_FALLING)
     * @param limit maximum number of transitions to return
     * @return array of long timestamps in order from the most recent
     */
    public long[] getOutputTransitions(int chan, int edge, int limit) {}
    
    /** 
     * Returns array of Output transition timestamps for the specified channel.
     * 
     * @param chan selected channel (0-N)
     * @return array of long timestamps in order from the most recent
     */
    public long[] getOutputTransitions(int chan) {}
    
    /** 
     * Returns array of Input transition timestamps for the specified channel.
     * 
     * @param chan selected channel (0-N)
     * @param edge selected transition type (EDGE_ANY, EDGE_RISING or EDGE_FALLING)
     * @param limit maximum number of transitions to return
     * @return array of long timestamps in order from the most recent
     */
    public long[] getInputTransitions(int chan, int edge, int limit) {}
    
    /** 
     * Fetch the Input event associated with a specific timestamp.
     * 
     * @param timestamp precise timestamp of an event
     * @return IoEvent object if one exists, null otherwise
     */
    public IoEvent getInputEvent(long timestamp) {}
    
    /** 
     * Fetch the Output event associated with a specific timestamp.
     * 
     * @param timestamp precise timestamp of an event
     * @return IoEvent object if one exists, null otherwise
     */
    public IoEvent getOutputEvent(long timestamp) {}
   
    /** 
     * Obtain one or more input signal periods
     * 
     * @param chan specified input channel
     * @return long[] containing periods in milliseconds in order from the most recent
     */
    public long[] getInputPeriod(int chan) {}
    
    /** 
     * Obtain one or more input signal periods
     * 
     * @param chan specified input channel
     * @param limit maximum number of periods to return
     * @return long[] containing periods in milliseconds in order from the most recent
     */
    public long[] getInputPeriod(int chan, int limit) {}

