
/*---------------------------------------------------------------------------
 * Copyright (C) 1999,2000 Dallas Semiconductor Corporation, All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Dallas Semiconductor
 * shall not be used except as stated in the Dallas Semiconductor
 * Branding Policy.
 *---------------------------------------------------------------------------
 */

package com.integpg.io;



import java.io.*;


/**
 *  12-8-00 KLA - added useModifiedUTF8 to do the wierd Java-UTF8, where the value 0
 *                is encoded as 2 bytes, rather than 1.  this allows java.io.RandomAccessFile
 *                and java.io.DataOutputStream to use this class.
 */
public class CharToByteUTF8
   extends CharToByteConverter
{

   private boolean useModifiedUTF8 = false;

    /**
     *
     * @param src ?
     * @param srcStart ?
     * @param dst ?
     * @param dstStart ?
     * @param len ?
     * @param useModifiedUTF8 ?
     * @return ?
     */
    public static native int convertCharToUTF8(char[] src, int srcStart,
                                              byte[] dst, int dstStart, 
                                              int len, boolean useModifiedUTF8);

    /**
     *
     * @param str ?
     * @param offset ?
     * @param dst ?
     * @param dstStart ?
     * @param len ?
     * @return ?
     */
    public static native int convertStringToUTF8(String str, int offset, 
                                               byte[] dst, int dstStart, int len);

    /**
     *
     * @param src ?
     * @param srcStart ?
     * @param len ?
     * @param useModifiedUTF8 ?
     * @return ?
     */
    public static native int getCharToUTF8Length(char[] src, int srcStart,
                                                int len, boolean useModifiedUTF8);

    /**
     *
     * @param str ?
     * @param offset ?
     * @param len ?
     * @return ?
     */
    public static native int getStringToUTF8Length(String str, int offset, int len);

   /**
    *
     * @return  ?
    */
   @Override
   public int getMaxByteCount (char[] forThis, int start, int end)
   {}

   /**
    *
     * @return  ?
     * @throws java.io.CharConversionException ?
    */
   @Override
   public int convert (char[] src, int srcStart, int srcEnd, byte[] dst,
                       int dstStart, int dstEnd)
      throws CharConversionException
   {}

   /**
    *
     * @param length ?
     * @return  ?
    */
   @Override
   public int flush (byte[] buff, int start, int length)
   {}

   /**
    *
     * @return  ?
    */
   @Override
   public String getName ()
   {}

    /**
     *
     * @param useMod ?
     */
    public void useModifiedUTF8(boolean useMod)
   {}

    /**
     *
     * @param str ?
     * @param writer ?
     * @return ?
     * @throws IOException ?
     */
    public static int write(String str, DataOutput writer)
        throws IOException
   {}
}
