//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/

/*
 * JANOS implementation.
 *
 * The legacy JNIOR3 methods have been provided. JANOS offers much more powerful set of static methods
 * which provied direct array access to the immutable block.
 */
package com.integpg.system;

import java.io.*;

/**
 * Creates and manages immutable (nonvolatile) data objects. These reside in high speed memory. Note that 
 * immutable blocks are lost if REBOOT -A is used to reset the heap. You can use the NV command to list
 * the existing blocks.
 * 
 * @author Bruce Cloutier
 */
public class Immutable {

    private int m_handle;
    private String m_ident;

    // Legacy native services
    private static native Object immGetArray(byte[] identifier);
    private static native Object immNewArray(byte[] identifier, int type, int size);
    private static native int immGetHandle(byte[] identifier) throws IOException;
    private static native int immCreate(byte[] identifier, int size);
    private static native void immRemove(byte[] identifier);
    private static native byte immGetByte(int handle, int address);
    private static native short immGetShort(int handle, int address);
    private static native int immGetInt(int handle, int address);
    private static native long immGetLong(int handle, int address);
    private static native void immGetBytes(int handle, int address, byte[] bufr, int offset, int length);
    private static native void immPutByte(int handle, int address, int value);
    private static native void immPutShort(int handle, int address, int value);
    private static native void immPutInt(int handle, int address, int value);
    private static native void immPutLong(int handle, int address, long value);
    private static native void immPutBytes(int handle, int address, byte[] bufr, int offset, int length);
    private static native int immGetSize(int handle);

    private static final String NOT_OPEN = "not open";
    private static final String ALREADY_OPEN = "already open";
    private static final String OUT_OF_BOUNDS = "out of bounds";

    /**
     * Creates a new instance of Immutable.
     */
    public Immutable() {}

    /**
     * Constructs an {@code Immutable} object for the block with the specified identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block. This must be exactly 8
     * characters in length.
     * @throws IOException if the Immutable is already open or if a block with the specified 
     * identifier does not exit.
     */
    public Immutable(String identifier) throws IOException {}

    // Object
    /**
     * Returns the immutable Object associated with the given identifier.
     *
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the Object
     */
    public static Object getArray(String identifier) {}

    // boolean[]
    /**
     * Constructs an immutable boolean[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static boolean[] createBooleanArray(String identifier, int size) {}

    /**
     * Returns the immutable boolean[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static boolean[] getBooleanArray(String identifier) {}

    // char[]
    /**
     * Constructs an immutable char[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static char[] createCharArray(String identifier, int size) {}

    /**
     * Returns the immutable char[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static char[] getCharArray(String identifier) {}

    // byte[]
    /**
     * Constructs an immutable byte[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static byte[] createByteArray(String identifier, int size) {}

    /**
     * Returns the immutable byte[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static byte[] getByteArray(String identifier) {}

    // short[]
    /**
     * Constructs an immutable short[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static short[] createShortArray(String identifier, int size) {}

    /**
     * Returns the immutable short[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static short[] getShortArray(String identifier) {}

    // int[]
    /**
     * Constructs an immutable int[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static int[] createIntArray(String identifier, int size) {}

    /**
     * Returns the immutable int[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static int[] getIntArray(String identifier) {}

    // long[]
    /**
     * Constructs an immutable long[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static long[] createLongArray(String identifier, int size) {}

    /**
     * Returns the immutable long[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static long[] getLongArray(String identifier) {}

    // float[]
    /**
     * Constructs an immutable float[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static float[] createFloatArray(String identifier, int size) {}

    /**
     * Returns the immutable float[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static float[] getFloatArray(String identifier) {}

    // double[]
    /**
     * Constructs an immutable double[] with the given identifier (GUID).
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * 
     * @param size count of elements in the new array
     * @return the new array
     */
    public static double[] createDoubleArray(String identifier, int size) {}

    /**
     * Returns the immutable double[] associated with the given identifier.
     * 
     * @param identifier an 8 character String that will uniquely identify this Immutable block.
     * @return the array if found; NULL otherwise
     */
    public static double[] getDoubleArray(String identifier) {}

    /**
     * Determines if the specified block exists.
     *
     * @param identifier An 8 character String that will uniquely identify this Immutable block. This must be exactly 8
     * characters in length.
     * @return Returns {@code true} if the block exists and {@code false} otherwise.
     */
    public synchronized boolean exists(String identifier) {}

    /**
     * Opens an existing Immutable block that had once been created with the specified 8 character identifier.
     *
     * @param identifier An 8 character String that will uniquely identify this Immutable block. This must be exactly 8
     * characters in length.
     * @throws IOException If the Immutable is already open or if a block with the specified 
     * identifier does not exit.
     */
    public synchronized void open(String identifier) throws IOException {}

    /**
     * Ends access to a previously opened/created immutable block.
     */
    public synchronized void close() {}

    /**
     * Check open status.
     *
     * @return Returns true if a block is open.
     */
    public synchronized boolean isOpen() {}

    /**
     * Creates a new immutable block and associates that block with the specified identifier. The identifier must be exactly 8
     * characters in length. If the block already exists it will be deleted and recreated.
     *
     * @param identifier 8 character identification string to be associated with the new immutable block. This must be exactly 8
     * characters in length of an IOException will be thrown.
     * @param size Defines the size of the new immutable block. As there is some minimal header information stored with the
     * block the size is limited to just under 64Kb.
     * @throws IOException The exception is thrown if the identifier is not exactly 8 characters in length. An exception will
     * occur if the requested block cannot be created.
     */
    public synchronized void create(String identifier, int size) throws IOException {}

    /**
     * Removes the specified immutable block from the heap.
     *
     * @param identifier 8 character string identifying an previously created immutable block.
     */
    public static void remove(String identifier) {}

    /**
     * Writes an array of bytes to the given address from the supplied byte[] starting with the byte at offset for count bytes.
     *
     * @param address Specifies the destination address within the immutable block.
     * @param array The byte[] containing the data to be written.
     * @param offset The offset in the byte[] defining the beginning of the data.
     * @param count The total length of the transfer.
     */
    public synchronized void writeBytes(int address, byte[] array, int offset, int count) {}

    /**
     * Reads a byte from the immutable block.
     *
     * @param address Specifies that address in the immutable block to be retrieved.
     * @return The byte value.
     * @deprecated as of JANOS
     */
    public synchronized int read(int address) {}

    /**
     * Reads a byte from the immutable block.
     *
     * @param address Specifies that address in the immutable block to be retrieved.
     * @return The byte value.
     */
    public synchronized byte readByte(int address) {}

    /**
     * Reads a short from the immutable block.
     *
     * @param address Specifies that address in the immutable block to be retrieved.
     * @return The short value.
     */
    public synchronized short readShort(int address) {}

    /**
     * Reads an int from the immutable block.
     *
     * @param address Specifies that address in the immutable block to be retrieved.
     * @return The int value.
     */
    public synchronized int readInt(int address) {}

    /**
     * Reads a long from the immutable block.
     *
     * @param address Specifies that address in the immutable block to be retrieved.
     * @return The long value.
     */
    public synchronized long readLong(int address) {}

    /**
     * Reads an array of bytes from the immutable block.
     *
     * @param address Specifies that address in the immutable block at the start of the data to be retrieved.
     * @param array The destination byte[].
     * @param offset The offset in the destination byte[] which will receive the data.
     * @param count The total length of the transfer. write beyond the bounds of the byte[].
     */
    public synchronized void readBytes(int address, byte[] array, int offset, int count) {}

    /**
     * Writes a byte to the given address.
     *
     * @param address Specifies the destination address within the immutable block.
     * @param value The byte to be written.
     * @deprecated as of JANOS throw the exception if the block is not open.
     */
    public synchronized void write(int address, int value) {}

    /**
     * Writes a byte to the given address.
     *
     * @param address Specifies the destination address within the immutable block.
     * @param value The byte to be written. throw the exception if the block is not open.
     */
    public synchronized void writeByte(int address, byte value) {}

    /**
     * Sets a 2-byte short value at the specified address.
     *
     * @param address The location of the short value in the immutable block.
     * @param value Short value to be written.
     */
    public synchronized void writeShort(int address, short value) {}

    /**
     * Writes an int value to the immutable block.
     *
     * @param address The destination location in the immutable block.
     * @param value The int to be written.
     */
    public synchronized void writeInt(int address, int value) {}

    /**
     * Writes a long value to the immutable block.
     *
     * @param address The destination location in the immutable block.
     * @param value The long value to be written
     */
    public synchronized void writeLong(int address, long value) {}

    /**
     * Returns the size of the immutable block.
     *
     * @return Returns the size of the block in bytes.
     */
    public synchronized int size() {}
}
