package com.integ.common.utils;

import com.integpg.system.JANOS;

/**
 * A helper class for reading from the registry. This the methods here will populate the keys with
 * the default values if
 * the keys do not exist.
 */
public class RegistryUtils {

    private static final String EMPTY_STRING = "";



    /**
     * Reads a STRING from the registry. If the registry key does not exist populate it with the
     * default value.
     * @param keyName
     * @param defaultValue
     * @return 
     */
    public static String getRegistryKey(String keyName, String defaultValue) {
        String value = JANOS.getRegistryString(keyName, EMPTY_STRING);
        if (value.equals(EMPTY_STRING)) {
            value = defaultValue;
            JANOS.setRegistryString(keyName, value);
        }
        return value;
    }



    /**
     * Reads a STRING ARRAY from the registry. If the registry key does not exist populate it with
     * the default value.
     */
    public static String[] getRegistryKeys(String keyName, String defaultValue) {
        String[] value = null;
        try {
            value = JANOS.getRegistryKey(keyName);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        if (value == null || value.length == 0) {
            if (defaultValue != null && !defaultValue.equals("")) {
                JANOS.setRegistryString(keyName, defaultValue);
            }
            try {
                value = JANOS.getRegistryKey(keyName);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return value;
    }



    /**
     * Reads a BOOLEAN from the registry. If the registry key does not exist populate it with the
     * default value.
     */
    public static boolean getRegistryKey(String keyName, boolean defaultValue) {
        boolean value = JANOS.getRegistryBoolean(keyName, defaultValue);
        if (value == defaultValue) {
            JANOS.setRegistryString(keyName, String.valueOf(value));
        }
        return value;
    }



    /**
     * Reads a DOUBLE from the registry. If the registry key does not exist populate it with the
     * default value.
     */
    public static double getRegistryKey(String keyName, double defaultValue) {
        double value = JANOS.getRegistryDouble(keyName, Double.MIN_VALUE);
        if (value == Double.MIN_VALUE) {
            value = defaultValue;
            JANOS.setRegistryString(keyName, Double.toString(value));
        }
        return value;
    }



    /**
     * Reads an INTEGER from the registry. If the registry key does not exist populate it with the
     * default value.
     */
    public static int getRegistryKey(String keyName, int defaultValue) {
        int value = JANOS.getRegistryInt(keyName, Integer.MIN_VALUE);
        if (value == Integer.MIN_VALUE) {
            value = defaultValue;
            JANOS.setRegistryString(keyName, Integer.toString(value));
        }
        return value;
    }

}

