package com.integ.common.utils;

import com.integpg.system.JANOS;
import java.io.*;

public class FileUtils {

    public static void writeAllBytes(String filename, byte[] bytes) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            fos.write(bytes);
            fos.flush();
        } catch (Exception ex) {
            JANOS.syslog("writeAllBytes to " + filename + " threw " + ex.getMessage(), JANOS.SYSLOG_ERROR);
        } finally {
            try {
                if (null != fos) fos.close();
            } catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }



    public static void appendAllBytes(String filename, byte[] bytes) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename, true);
            fos.write(bytes);
            fos.flush();
        } catch (Exception ex) {
            JANOS.syslog("appendAllBytes to " + filename + " threw " + ex.getMessage(), JANOS.SYSLOG_ERROR);
        } finally {
            try {
                if (null != fos) fos.close();
            } catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }



    public static void appendBytes(String filename, byte[] bytes, int offset, int length) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename, true);
            fos.write(bytes, offset, length);
            fos.flush();
        } catch (Exception ex) {
            JANOS.syslog("appendAllBytes to " + filename + " threw " + ex.getMessage(), JANOS.SYSLOG_ERROR);
        } finally {
            try {
                if (null != fos) fos.close();
            } catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }



    public static byte[] readAllBytes(String filename) throws IOException {
        File file = new File(filename);
        byte[] bytes = new byte[(int) file.length()];
        FileInputStream fis = new FileInputStream(file.getPath());
        DataInputStream dis = new DataInputStream(fis);
        try {
            dis.readFully(bytes);
        } finally {
            dis.close();
        }
        return bytes;
    }



    /**
     * added 3.5
     */
    public static String readAllText(String filename) throws IOException {
        byte[] fileBytes = readAllBytes(filename);
        String fileContent = new String(fileBytes);
        return fileContent;
    }



    /**
     * copies file contents from one file starting at a specified file position to another file starting at a specified
     * file position
     */
    public static void copyfile(File srcFile, int srPos, File dstFile, int dtPos) {
        try {
            long start = System.currentTimeMillis();

            RandomAccessFile in = new RandomAccessFile(srcFile, "r");
            in.seek(srPos);

            //For Overwrite the file.
            RandomAccessFile out = new RandomAccessFile(dstFile, "rw");
            out.seek(dtPos);

            byte[] buf = new byte[16 * 1024];
            int len;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();

            long elapsed = System.currentTimeMillis() - start;
            System.out.println("took " + elapsed + " to copy " + srcFile.getAbsolutePath() + " to " + dstFile.getAbsolutePath());
        } catch (Exception ex) {
            System.err.println("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + ex.toString());
        }
    }
}

