package com.integ.common.system;

import java.util.ArrayList;

public class ReleaseInfo {

    private final String _version;
    private final String _date;
    private final ArrayList<String> _releaseNotes = new ArrayList<>();



    public ReleaseInfo(String version, String date) {
        _version = version;
        _date = date;
    }



    public String getVersion() {
        return _version;
    }



    public String getDate() {
        return _date;
    }



    public ArrayList<String> getReleaseNotes() {
        return _releaseNotes;
    }



    public ReleaseInfo addNote(String note) {
        _releaseNotes.add(note);
        return this;
    }
}

